/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.ConfigurationParameter;
import fitnesse.ContextConfigurator;
import util.CommandLine;

public class Arguments {
    private final CommandLine commandLine = new CommandLine("[-v][-p port][-d dir][-r root][-l logDir][-f config][-e days][-o][-i][-a credentials][-c command][-b output]");
    private final String rootPath;
    private final Integer port;
    private final String rootDirectory;
    private final String logDirectory;
    private final boolean omitUpdate;
    private final Integer daysTillVersionsExpire;
    private final String credentials;
    private final boolean installOnly;
    private final String command;
    private final String output;
    private final String configFile;
    private final boolean verboseLogging;

    public Arguments(String ... args) {
        if (!this.commandLine.parse(args)) {
            throw new IllegalArgumentException("Can not parse command line");
        }
        String port = this.commandLine.getOptionArgument("p", "port");
        this.port = port != null ? Integer.valueOf(port) : null;
        this.rootPath = this.commandLine.getOptionArgument("d", "dir");
        this.rootDirectory = this.commandLine.getOptionArgument("r", "root");
        this.logDirectory = this.commandLine.getOptionArgument("l", "logDir");
        String days = this.commandLine.getOptionArgument("e", "days");
        this.daysTillVersionsExpire = days != null ? Integer.valueOf(days) : null;
        this.credentials = this.commandLine.getOptionArgument("a", "credentials");
        this.command = this.commandLine.getOptionArgument("c", "command");
        this.output = this.commandLine.getOptionArgument("b", "output");
        this.configFile = this.commandLine.getOptionArgument("f", "config");
        this.verboseLogging = this.commandLine.hasOption("v");
        this.omitUpdate = this.commandLine.hasOption("o");
        this.installOnly = this.commandLine.hasOption("i");
    }

    static void printUsage() {
        ContextConfigurator defaults = ContextConfigurator.systemDefaults();
        System.err.println("Usage: java -jar fitnesse.jar [-vpdrleoab]");
        System.err.println("\t-p <port number> {80}");
        System.err.println("\t-d <working directory> {" + defaults.get(ConfigurationParameter.ROOT_PATH) + "}");
        System.err.println("\t-r <page root directory> {" + defaults.get(ConfigurationParameter.ROOT_DIRECTORY) + "}");
        System.err.println("\t-l <log directory> {no logging}");
        System.err.println("\t-f <config properties file> {" + defaults.get(ConfigurationParameter.CONFIG_FILE) + "}");
        System.err.println("\t-e <days> {" + defaults.get(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS) + "} Number of days before page versions expire");
        System.err.println("\t-o omit updates");
        System.err.println("\t-a {user:pwd | user-file-name} enable authentication.");
        System.err.println("\t-i Install only, then quit.");
        System.err.println("\t-c <command> execute single command.");
        System.err.println("\t-b <filename> redirect command output.");
        System.err.println("\t-v {off} Verbose logging");
    }

    public String getRootPath(ContextConfigurator configurator) {
        return this.rootPath == null ? configurator.get(ConfigurationParameter.ROOT_PATH) : this.rootPath;
    }

    public String getConfigFile(ContextConfigurator configurator) {
        return this.configFile == null ? this.getRootPath(configurator) + "/" + configurator.get(ConfigurationParameter.CONFIG_FILE) : this.configFile;
    }

    public ContextConfigurator update(ContextConfigurator defaults) {
        ContextConfigurator result = defaults;
        result = result.withParameter(ConfigurationParameter.LOG_LEVEL, this.verboseLogging ? "verbose" : "normal");
        if (this.configFile != null) {
            result = result.withParameter(ConfigurationParameter.CONFIG_FILE, this.configFile);
        }
        if (this.port != null) {
            result = result.withPort(this.port);
        }
        if (this.rootPath != null) {
            result = result.withRootPath(this.rootPath);
        }
        if (this.rootDirectory != null) {
            result = result.withRootDirectoryName(this.rootDirectory);
        }
        if (this.output != null) {
            result = result.withParameter(ConfigurationParameter.OUTPUT, this.output);
        }
        if (this.logDirectory != null) {
            result = result.withParameter(ConfigurationParameter.LOG_DIRECTORY, this.logDirectory);
        }
        if (this.daysTillVersionsExpire != null) {
            result = result.withParameter(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS, this.daysTillVersionsExpire.toString());
        }
        if (this.omitUpdate) {
            result = result.withParameter(ConfigurationParameter.OMITTING_UPDATES, "true");
        }
        if (this.installOnly) {
            result = result.withParameter(ConfigurationParameter.INSTALL_ONLY, "true");
        }
        if (this.command != null) {
            result = result.withParameter(ConfigurationParameter.COMMAND, this.command);
        }
        if (this.credentials != null) {
            result = result.withParameter(ConfigurationParameter.CREDENTIALS, this.credentials);
        }
        return result;
    }
}

