/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.testsystems.CompositeTestSystemListener;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.testsystems.fit.FitClientListener;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

public class FitTestSystem
implements TestSystem,
FitClientListener {
    protected static final String EMPTY_PAGE_CONTENT = "OH NO! This page is empty!";
    private final CompositeTestSystemListener testSystemListener;
    private final String testSystemName;
    private final CommandRunningFitClient client;
    private Deque<TestPage> processingQueue = new LinkedList<TestPage>();
    private TestPage currentTestPage;

    public FitTestSystem(String testSystemName, CommandRunningFitClient fitClient) {
        this.testSystemListener = new CompositeTestSystemListener();
        this.testSystemName = testSystemName;
        this.client = fitClient;
        this.client.addFitClientListener(this);
    }

    @Override
    public String getName() {
        return this.testSystemName;
    }

    @Override
    public void start() throws IOException {
        this.client.start();
        this.testSystemStarted(this);
    }

    @Override
    public void runTests(TestPage pageToTest) throws IOException, InterruptedException {
        this.processingQueue.addLast(pageToTest);
        String html = pageToTest.getHtml();
        try {
            if (html.isEmpty()) {
                this.client.send(EMPTY_PAGE_CONTENT);
            } else {
                this.client.send(html);
            }
        }
        catch (InterruptedException e) {
            this.exceptionOccurred(e);
            throw e;
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void bye() throws IOException, InterruptedException {
        this.client.done();
        this.client.join();
        this.testSystemStopped(null);
    }

    @Override
    public void kill() {
        this.client.kill();
    }

    @Override
    public void addTestSystemListener(TestSystemListener listener) {
        this.testSystemListener.addTestSystemListener(listener);
    }

    @Override
    public void testOutputChunk(String output) throws IOException {
        if (this.currentTestPage == null) {
            this.currentTestPage = this.processingQueue.removeFirst();
            this.testSystemListener.testStarted(this.currentTestPage);
        }
        this.testSystemListener.testOutputChunk(output);
    }

    @Override
    public void testComplete(TestSummary testSummary) throws IOException {
        assert (this.currentTestPage != null);
        this.testSystemListener.testComplete(this.currentTestPage, testSummary);
        this.currentTestPage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionOccurred(Throwable t) {
        try {
            this.client.kill();
        }
        finally {
            this.testSystemStopped(t);
        }
    }

    private void testSystemStarted(TestSystem testSystem) throws IOException {
        this.testSystemListener.testSystemStarted(testSystem);
    }

    private void testSystemStopped(Throwable throwable) {
        this.testSystemListener.testSystemStopped(this, throwable);
    }

    @Override
    public boolean isSuccessfullyStarted() {
        return this.client.isSuccessfullyStarted();
    }
}

