/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ListConverterHelper;
import fitnesse.util.StringUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class GenericArrayConverter<T>
implements Converter<Object> {
    private final Class<T> componentClass;
    private final Converter<T> componentConverter;

    public GenericArrayConverter(Class<T> componentClass, Converter<T> componentConverter) {
        this.componentClass = componentClass;
        this.componentConverter = componentConverter;
    }

    @Override
    public String toString(Object array) {
        if (array == null) {
            return NULL_VALUE;
        }
        int size = Array.getLength(array);
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.componentConverter.toString(Array.get(array, i)));
        }
        return ((Object)ret).toString();
    }

    @Override
    public Object fromString(String arg) {
        if (StringUtils.isBlank(arg)) {
            return null;
        }
        String[] strings = ListConverterHelper.fromStringToArrayOfStrings(arg);
        Object array = Array.newInstance(this.componentClass, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            Array.set(array, i, this.componentConverter.fromString(strings[i]));
        }
        return array;
    }
}

