/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateConverter
implements Converter<Date> {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);

    @Override
    public String toString(Date o) {
        return o != null ? DATE_FORMAT.format(o) : NULL_VALUE;
    }

    @Override
    public Date fromString(String arg) {
        if (StringUtils.isBlank(arg)) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(arg);
        }
        catch (ParseException e) {
            throw new SlimError("Can't parse date " + arg, e);
        }
    }
}

