/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.wiki.fs.FileVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class RenameFileResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, final Request request) throws IOException {
        File pathName;
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        File rootPath = new File(context.getRootPagePath());
        if (!FileResponder.isInFilesDirectory(rootPath, pathName = new File(rootPath, resource))) {
            return new ErrorResponder("Invalid path: " + resource).makeResponse(context, request);
        }
        String oldFileName = request.getInput("filename");
        String newFileName = request.getInput("newName").trim();
        File oldFile = new File(pathName, oldFileName);
        final File newFile = new File(pathName, newFileName);
        if (!FileResponder.isInFilesDirectory(rootPath, oldFile)) {
            return new ErrorResponder("Invalid path: " + oldFileName).makeResponse(context, request);
        }
        if (!FileResponder.isInFilesDirectory(rootPath, newFile)) {
            return new ErrorResponder("Invalid path: " + newFileName).makeResponse(context, request);
        }
        context.versionsController.rename(new FileVersion(){

            @Override
            public File getFile() {
                return newFile;
            }

            @Override
            public InputStream getContent() throws IOException {
                return null;
            }

            @Override
            public String getAuthor() {
                String user = request.getAuthorizationUsername();
                return user != null ? user : "";
            }

            @Override
            public Date getLastModificationTime() {
                return new Date();
            }
        }, oldFile);
        response.redirect(context.contextRoot, resource);
        return response;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

