/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RssResponder
implements SecureResponder {
    private RssFeed feed;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPage contextPage = this.getContextPage(context, request.getResource());
        WikiPage recentChangesPage = context.getRootPage().getChildPage("RecentChanges");
        this.feed = new RssFeed(this.getConfiguredRssLinkPrefixFrom(contextPage));
        this.buildItemReportIfRecentChangesExists(recentChangesPage, request.getResource());
        return this.feed.asResponse();
    }

    private WikiPage getContextPage(FitNesseContext context, String resource) throws Exception {
        PageCrawler pageCrawler = context.getRootPage().getPageCrawler();
        WikiPagePath resourcePath = PathParser.parse(resource);
        return pageCrawler.getPage(resourcePath);
    }

    protected void buildItemReportIfRecentChangesExists(WikiPage recentChangesPage, String resource) throws Exception {
        if (recentChangesPage != null) {
            this.buildItemReport(resource, new RecentChangesPage(recentChangesPage));
        }
    }

    private void buildItemReport(String resource, RecentChangesPage recentChangesPage) throws Exception {
        for (RecentChangesPageEntry line : recentChangesPage.getLinesApplicableTo(resource)) {
            this.feed.addItem(line);
        }
    }

    private String getConfiguredRssLinkPrefixFrom(WikiPage contextPage) throws Exception {
        if (contextPage == null) {
            return null;
        }
        return contextPage.getVariable("RSS_PREFIX");
    }

    protected static boolean isNeitherNullNorBlank(String string) {
        return string != null && !string.isEmpty();
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    static class LinkPrefixBuilder {
        private String preconfiguredPrefix;

        LinkPrefixBuilder(String preconfiguredPrefix) {
            this.preconfiguredPrefix = preconfiguredPrefix;
        }

        public void buildLink(Element itemElement, String pageName) throws Exception {
            String prefix = this.getRssLinkPrefix();
            String link = prefix + pageName;
            XmlUtil.addTextNode(itemElement, "link", link);
        }

        private static String hostnameRssLinkPrefix() throws UnknownHostException {
            String hostName = InetAddress.getLocalHost().getHostName();
            return "http://" + hostName + "/";
        }

        private String getRssLinkPrefix() throws Exception {
            return this.preconfiguredPrefix == null ? LinkPrefixBuilder.hostnameRssLinkPrefix() : this.preconfiguredPrefix;
        }
    }

    static class RecentChangesPageEntry {
        private String line;

        RecentChangesPageEntry(String line) {
            this.line = line;
        }

        public Map<String, String> getItemProperties() {
            String[] fields = this.convertTableLineToStrings();
            HashMap<String, String> itemProperties = new HashMap<String, String>();
            itemProperties.put("path", fields[1]);
            itemProperties.put("author", fields[2]);
            itemProperties.put("pubDate", RecentChangesPageEntry.convertDateFormat(fields[3]));
            return itemProperties;
        }

        protected boolean relatesTo(String resource) {
            String path = this.getItemProperties().get("path");
            boolean blank = RssResponder.isNeitherNullNorBlank(resource);
            return !blank || path.startsWith(resource);
        }

        private String[] convertTableLineToStrings() {
            return this.line.split("\\|");
        }

        static String convertDateFormat(String dateIn) {
            Pattern timePattern = Pattern.compile("\\d*:\\d*:\\d* \\w*, \\w* \\d*, \\d*");
            Matcher m = timePattern.matcher(dateIn);
            if (m.matches()) {
                return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z").format(new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy").parse(dateIn, new ParsePosition(0)));
            }
            return dateIn;
        }
    }

    static class RecentChangesPage {
        private WikiPage page;

        RecentChangesPage(WikiPage page) {
            this.page = page;
        }

        public List<RecentChangesPageEntry> getLinesApplicableTo(String resource) throws Exception {
            ArrayList<RecentChangesPageEntry> filteredLines = new ArrayList<RecentChangesPageEntry>();
            for (RecentChangesPageEntry line : this.getLines()) {
                if (!line.relatesTo(resource)) continue;
                filteredLines.add(line);
            }
            return filteredLines;
        }

        private List<RecentChangesPageEntry> getLines() throws Exception {
            ArrayList<RecentChangesPageEntry> lines = new ArrayList<RecentChangesPageEntry>();
            for (String lineString : this.getPageContentLines()) {
                lines.add(new RecentChangesPageEntry(lineString));
            }
            return lines;
        }

        private String[] getPageContentLines() throws Exception {
            PageData data = this.page.getData();
            String content = data.getContent();
            return content.split("\n");
        }
    }

    static class RssFeed {
        private Element channelElement;
        private final Document document = this.buildDocumentWithRssHeader();
        private final LinkPrefixBuilder linkPrefixBuilder;

        public RssFeed(String configuredLinkPrefix) throws Exception {
            this.linkPrefixBuilder = new LinkPrefixBuilder(configuredLinkPrefix);
        }

        public void addItem(RecentChangesPageEntry line) throws Exception {
            Map<String, String> itemProperties = line.getItemProperties();
            Element itemElement = this.document.createElement("item");
            RssFeed.makeNodes(itemElement, itemProperties);
            this.linkPrefixBuilder.buildLink(itemElement, itemProperties.get("path"));
            String description = RssFeed.makeDescription(itemProperties);
            XmlUtil.addTextNode(itemElement, "description", description);
            this.channelElement.appendChild(itemElement);
        }

        public SimpleResponse asResponse() throws Exception {
            String bytes = XmlUtil.xmlAsString(this.document);
            SimpleResponse response = new SimpleResponse();
            response.setContent(bytes);
            response.setContentType("text/xml");
            return response;
        }

        private static String makeDescription(Map<String, String> itemProperties) {
            String authoredBy = "";
            if (RssResponder.isNeitherNullNorBlank(itemProperties.get("author"))) {
                authoredBy = itemProperties.get("author") + ":";
            }
            String description = authoredBy + itemProperties.get("pubDate");
            return description;
        }

        private static void makeNodes(Element itemElement, Map<String, String> itemProperties) {
            XmlUtil.addTextNode(itemElement, "title", itemProperties.get("path"));
            XmlUtil.addTextNode(itemElement, "author", itemProperties.get("author"));
            XmlUtil.addTextNode(itemElement, "pubDate", itemProperties.get("pubDate"));
        }

        private Document buildDocumentWithRssHeader() throws Exception {
            Document rssDocument = XmlUtil.newDocument();
            Element rssDocumentElement = rssDocument.createElement("rss");
            rssDocument.appendChild(rssDocumentElement);
            this.channelElement = rssDocument.createElement("channel");
            rssDocumentElement.setAttribute("version", "2.0");
            rssDocumentElement.appendChild(this.channelElement);
            XmlUtil.addTextNode(this.channelElement, "title", "FitNesse:");
            return rssDocument;
        }
    }
}

