/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.http.Request;
import fitnesse.responders.BasicResponder;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class NameWikiPageResponder
extends BasicResponder {
    @Override
    protected String contentFrom(FitNesseContext context, Request request, WikiPage requestedPage) {
        List<String> lines = this.addLines(request, requestedPage, "");
        String format = request.getInput("format");
        if ("json".equalsIgnoreCase(format)) {
            JSONArray jsonPages = new JSONArray(lines);
            return jsonPages.toString();
        }
        return StringUtils.join(lines, System.getProperty("line.separator"));
    }

    private List<String> addLines(Request request, WikiPage requestedPage, String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        for (WikiPage child : requestedPage.getChildren()) {
            if (!request.hasInput("LeafOnly") || child.getChildren().isEmpty()) {
                lines.add(this.makeLine(request, child, prefix));
            }
            if (!request.hasInput("Recursive")) continue;
            lines.addAll(this.addLines(request, child, prefix + child.getName() + "."));
        }
        return lines;
    }

    private String makeLine(Request request, WikiPage child, String prefix) {
        Set<String> tags;
        int numberOfChildren = child.getChildren().size();
        StringBuilder line = new StringBuilder(64).append(prefix).append(child.getName());
        if (request.hasInput("ShowChildCount")) {
            line.append(" ").append(numberOfChildren);
        }
        if (request.hasInput("ShowTags") && !(tags = this.getTags(child)).isEmpty()) {
            line.append(" ");
            for (String tag : tags) {
                line.append("[").append(tag).append("]");
            }
        }
        return line.toString();
    }

    private Set<String> getTags(WikiPage page) {
        TreeSet<String> result = new TreeSet<String>();
        String tags = page.getData().getAttribute("Suites");
        if (tags != null && !tags.isEmpty()) {
            result.addAll(Arrays.asList(tags.split(", ")));
        }
        if (!page.isRoot()) {
            result.addAll(this.getTags(page.getParent()));
        }
        return result;
    }

    @Override
    protected String getContentType() {
        return "text/plain";
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

