/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.reporting.history.TestResultRecord;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.FileUtil;

public class PageHistoryReader {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String TEST_FILE_FORMAT = "\\A\\d{14}_\\d+_\\d+_\\d+_\\d+(.xml)*\\Z";

    void readHistoryFromPageDirectory(File pageDirectory) throws ParseException {
        File[] resultDir;
        for (File file : resultDir = FileUtil.getDirectoryListing(pageDirectory)) {
            if (!this.fileIsNotADirectoryAndIsValid(file)) continue;
            this.compileResultFileIntoHistory(file);
        }
    }

    private boolean fileIsNotADirectoryAndIsValid(File file) {
        return !file.isDirectory() && PageHistoryReader.matchesPageHistoryFileFormat(file.getName());
    }

    public static boolean matchesPageHistoryFileFormat(String pageHistoryFileName) {
        return pageHistoryFileName.matches(TEST_FILE_FORMAT);
    }

    private void compileResultFileIntoHistory(File file) throws ParseException {
        TestResultRecord record = this.buildTestResultRecord(file);
        this.processTestFile(record);
    }

    void processTestFile(TestResultRecord record) throws ParseException {
    }

    private TestResultRecord buildTestResultRecord(File file) throws ParseException {
        String[] parts = file.getName().split("_|\\.");
        Date date = this.dateFormat.parse(parts[0]);
        TestResultRecord testResultRecord = new TestResultRecord(file, date, Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]), Integer.parseInt(parts[4]));
        return testResultRecord;
    }
}

