/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.reporting.history.PageHistoryReader;
import fitnesse.reporting.history.TestResultRecord;
import java.io.File;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MostRecentPageHistoryReader
extends PageHistoryReader {
    private static final Logger LOG = Logger.getLogger(MostRecentPageHistoryReader.class.getName());
    TestResultRecord mostRecentRecord = null;
    File directory = null;

    public MostRecentPageHistoryReader(File pageDirectory) {
        this.directory = pageDirectory;
    }

    public TestResultRecord findMostRecentTestRun() {
        try {
            this.readHistoryFromPageDirectory(this.directory);
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, "Unable to read history from page directory", e);
        }
        return this.mostRecentRecord;
    }

    @Override
    void processTestFile(TestResultRecord record) throws ParseException {
        if (this.mostRecentRecord == null || this.mostRecentRecord.getDate().compareTo(record.getDate()) < 0) {
            this.mostRecentRecord = record;
        }
    }
}

