/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseVersion;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.util.DateTimeUtil;
import fitnesse.util.TimeMeasurement;
import fitnesse.util.XmlUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ExecutionReport {
    private String version;
    private String rootPath;
    private TestSummary finalCounts = new TestSummary(0, 0, 0, 0);
    public Date date;
    private long totalRunTimeInMillis = 0L;
    private List<ExecutionLogReport> executionLogs = new ArrayList<ExecutionLogReport>();

    protected ExecutionReport() {
        this.version = new FitNesseVersion().toString();
    }

    public ExecutionReport(FitNesseVersion version, String rootPath) {
        this.version = version == null ? "null" : version.toString();
        this.rootPath = rootPath;
    }

    public void tallyPageCounts(ExecutionResult result) {
        this.finalCounts.tallyPageCounts(result);
    }

    public String toString() {
        return this.rootPath;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExecutionReport)) {
            return false;
        }
        ExecutionReport e = (ExecutionReport)o;
        if (!StringUtils.equals(this.rootPath, e.rootPath)) {
            return false;
        }
        if (!StringUtils.equals(this.version, e.version)) {
            return false;
        }
        if (!DateTimeUtil.datesNullOrEqual(this.date, e.date)) {
            return false;
        }
        if (!this.finalCounts.equals(e.finalCounts)) {
            return false;
        }
        return this.totalRunTimeInMillis == e.totalRunTimeInMillis;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.rootPath).append(this.version).append(this.date).hashCode();
    }

    public static ExecutionReport makeReport(String xmlString) throws Exception {
        Document xmlDocument = XmlUtil.newDocument(xmlString);
        Element documentElement = xmlDocument.getDocumentElement();
        String documentNodeName = documentElement.getNodeName();
        if (documentNodeName.equals("testResults")) {
            return new TestExecutionReport(xmlDocument);
        }
        if (documentNodeName.equals("suiteResults")) {
            return new SuiteExecutionReport(xmlDocument);
        }
        throw new RuntimeException(String.format("%s is not a valid document element tag for an Execution Report.", documentNodeName));
    }

    protected void unpackCommonFields(Element documentElement) {
        this.version = XmlUtil.getTextValue(documentElement, "FitNesseVersion");
        this.rootPath = XmlUtil.getTextValue(documentElement, "rootPath");
        String dateString = XmlUtil.getTextValue(documentElement, "date");
        if (dateString != null) {
            this.date = DateTimeUtil.getDateFromString(dateString);
        }
        this.unpackFinalCounts(documentElement);
        this.totalRunTimeInMillis = this.getTotalRunTimeInMillisOrZeroIfNotPresent(documentElement);
    }

    protected long getTotalRunTimeInMillisOrZeroIfNotPresent(Element documentElement) {
        String textValue = XmlUtil.getTextValue(documentElement, "totalRunTimeInMillis");
        return textValue == null ? 0L : Long.parseLong(textValue);
    }

    private void unpackFinalCounts(Element testResults) {
        Element counts = XmlUtil.getElementByTagName(testResults, "finalCounts");
        if (counts != null) {
            this.finalCounts = new TestSummary(Integer.parseInt(XmlUtil.getTextValue(counts, "right")), Integer.parseInt(XmlUtil.getTextValue(counts, "wrong")), Integer.parseInt(XmlUtil.getTextValue(counts, "ignores")), Integer.parseInt(XmlUtil.getTextValue(counts, "exceptions")));
        }
    }

    protected void unpackXml(Document xmlDoc) {
        Element historyDocument = xmlDoc.getDocumentElement();
        this.unpackCommonFields(historyDocument);
        this.unpackResults(historyDocument);
        this.unpackExecutionLogs(historyDocument);
    }

    private void unpackExecutionLogs(Element historyDocument) {
        NodeList logs = historyDocument.getElementsByTagName("executionLog");
        if (logs == null) {
            return;
        }
        for (int i = 0; i < logs.getLength(); ++i) {
            NodeList exceptionNodes;
            Element log = (Element)logs.item(i);
            String commandLine = XmlUtil.getTextValue(log, "command");
            String testSystemName = XmlUtil.getTextValue(log, "testSystem");
            String exitCode = XmlUtil.getTextValue(log, "exitCode");
            String stdOut = XmlUtil.getTextValue(log, "stdOut");
            String stdErr = XmlUtil.getTextValue(log, "stdErr");
            ExecutionLogReport report = new ExecutionLogReport(commandLine, testSystemName);
            if (StringUtils.isNotBlank(exitCode)) {
                report.exitCode(Integer.parseInt(exitCode));
            }
            if (stdOut != null) {
                report.setStdOut(stdOut);
            }
            if (stdErr != null) {
                report.setStdErr(stdErr);
            }
            if ((exceptionNodes = log.getElementsByTagName("exception")) != null) {
                for (int k = 0; k < exceptionNodes.getLength(); ++k) {
                    report.exceptionOccurred(new Exception(exceptionNodes.item(k).getTextContent()));
                }
            }
            this.executionLogs.add(report);
        }
    }

    protected abstract void unpackResults(Element var1);

    public TestSummary getFinalCounts() {
        return this.finalCounts;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTotalRunTimeInMillis() {
        return this.totalRunTimeInMillis;
    }

    public void setTotalRunTimeInMillis(TimeMeasurement totalTimeMeasurement) {
        this.totalRunTimeInMillis = totalTimeMeasurement.elapsed();
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public boolean hasRunTimes() {
        return new FitNesseVersion(this.getVersion()).isAtLeast("v20100607");
    }

    public List<ExecutionLogReport> getExecutionLogs() {
        return this.executionLogs;
    }

    public void addExecutionContext(String command, String testSystemName) {
        this.executionLogs.add(new ExecutionLogReport(command, testSystemName));
    }

    private ExecutionLogReport executionLogReport() {
        ExecutionLogReport log;
        if (this.executionLogs.size() > 0) {
            log = this.executionLogs.get(this.executionLogs.size() - 1);
        } else {
            log = new ExecutionLogReport("", "");
            this.executionLogs.add(log);
        }
        return log;
    }

    public void addStdOut(String output) {
        this.executionLogReport().addStdOut(output);
    }

    public void addStdErr(String output) {
        this.executionLogReport().addStdErr(output);
    }

    public void exitCode(int exitCode) {
        this.executionLogReport().exitCode(exitCode);
    }

    public void exceptionOccurred(Throwable e) {
        this.executionLogReport().exceptionOccurred(e);
    }

    public static class ExecutionLogReport {
        private final String command;
        private final String testSystemName;
        private StringBuffer stdOut = new StringBuffer();
        private StringBuffer stdErr = new StringBuffer();
        private int exitCode;
        private List<Throwable> exceptions = new ArrayList<Throwable>();

        public ExecutionLogReport(String command, String testSystemName) {
            this.command = command;
            this.testSystemName = testSystemName;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTestSystemName() {
            return this.testSystemName;
        }

        public void addStdOut(String output) {
            this.stdOut.append(output).append("\n");
        }

        public void setStdOut(String output) {
            this.stdOut.append(output);
        }

        public String getStdOut() {
            return this.stdOut.toString();
        }

        public void addStdErr(String output) {
            this.stdErr.append(output).append("\n");
        }

        public void setStdErr(String output) {
            this.stdErr.append(output);
        }

        public String getStdErr() {
            return this.stdErr.toString();
        }

        public void exitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public void exceptionOccurred(Throwable e) {
            this.exceptions.add(e);
        }

        public List<Throwable> getExceptions() {
            return this.exceptions;
        }
    }
}

