/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.Fixture;
import fitnesse.authentication.Authenticator;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.responders.editing.SaveRecorder;
import fitnesse.testutil.FitNesseUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Properties;
import util.FileUtil;

public class SetUp
extends Fixture {
    public SetUp() throws Exception {
        this(new Properties());
    }

    public SetUp(String configuration) throws Exception {
        this(SetUp.asProperties(configuration));
    }

    private SetUp(Properties properties) throws Exception {
        int port = 9123;
        properties.setProperty("FITNESSE_PORT", String.valueOf(9123));
        FitnesseFixtureContext.context = FitNesseUtil.makeTestContext(9123, new Authenticator(){

            @Override
            public boolean isAuthenticated(String username, String password) {
                if (FitnesseFixtureContext.authenticator != null) {
                    return FitnesseFixtureContext.authenticator.isAuthenticated(username, password);
                }
                return true;
            }
        }, properties);
        FitnesseFixtureContext.context.fitNesse.dontMakeDirs();
        File historyDirectory = FitnesseFixtureContext.context.getTestHistoryDirectory();
        if (historyDirectory.exists()) {
            FileUtil.deleteFileSystemDirectory(historyDirectory);
        }
        historyDirectory.mkdirs();
        SaveRecorder.clear();
        FitnesseFixtureContext.context.fitNesse.start();
    }

    private static Properties asProperties(String configuration) throws Exception {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(configuration.getBytes("utf-8")));
        return properties;
    }
}

