/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseServer;
import fitnesse.http.MockRequestBuilder;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.socketservice.SocketFactory;
import fitnesse.socketservice.SocketService;
import fitnesse.util.MockSocket;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FitNesse {
    private static final Logger LOG = Logger.getLogger(FitNesse.class.getName());
    private final FitNesseContext context;
    private boolean makeDirs = true;
    private volatile SocketService theService;

    public FitNesse(FitNesseContext context) {
        this.context = context;
    }

    public FitNesse dontMakeDirs() {
        this.makeDirs = false;
        return this;
    }

    private void establishRequiredDirectories() {
        FitNesse.establishDirectory(this.context.getRootPagePath());
        FitNesse.establishDirectory(this.context.getRootPagePath() + "/files");
    }

    private static void establishDirectory(String path) {
        File filesDir = new File(path);
        if (!filesDir.exists()) {
            filesDir.mkdir();
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("DEPRECATED:  use java -jar fitnesse.jar or java -cp fitnesse.jar fitnesseMain.FitNesseMain");
        Class<?> mainClass = Class.forName("fitnesseMain.FitNesseMain");
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    public boolean start() {
        if (this.makeDirs) {
            this.establishRequiredDirectories();
        }
        try {
            if (this.context.port > 0) {
                ServerSocket serverSocket = SocketFactory.tryCreateServerSocket(this.context.port, this.context.useHTTPS, this.context.sslClientAuth, this.context.sslParameterClassName);
                this.theService = new SocketService(new FitNesseServer(this.context), false, serverSocket);
            }
            return true;
        }
        catch (BindException e) {
            LOG.severe("FitNesse cannot be started...");
            LOG.severe("Port " + this.context.port + " is already in use.");
            LOG.severe("Use the -p <port#> command line argument to use a different port.");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while starting the FitNesse socket service", e);
        }
        return false;
    }

    public void stop() throws IOException {
        if (this.theService != null) {
            this.theService.close();
            this.theService = null;
        }
    }

    public boolean isRunning() {
        return this.theService != null;
    }

    public void executeSingleCommand(String command, OutputStream out) throws Exception {
        Request request = new MockRequestBuilder(command).noChunk().build();
        FitNesseExpediter expediter = new FitNesseExpediter(new MockSocket(), this.context);
        Response response = expediter.createGoodResponse(request);
        response.withoutHttpHeaders();
        MockResponseSender.OutputStreamSender sender = new MockResponseSender.OutputStreamSender(out);
        ((MockResponseSender)sender).doSending(response);
    }
}

