/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.FitMatcher;
import fit.FixtureListener;
import fit.FixtureLoader;
import fit.NullFixtureListener;
import fit.Parse;
import fit.SemaphoreFixture;
import fit.TypeAdapter;
import fit.exception.CouldNotParseFitFailureException;
import fit.exception.FitFailureException;
import fit.exception.FitMatcherException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Fixture {
    public Map<String, Object> summary = new HashMap<String, Object>();
    public Counts counts = new Counts();
    public FixtureListener listener = new NullFixtureListener();
    protected String[] args;
    private static final Map<String, Object> symbols = new HashMap<String, Object>();
    private static boolean forcedAbort = false;

    public static void setForcedAbort(boolean state) {
        forcedAbort = state;
    }

    protected Class<?> getTargetClass() {
        return this.getClass();
    }

    public void doTables(Parse tables) {
        Parse heading;
        this.summary.put("run date", new Date());
        this.summary.put("run elapsed time", new RunTime());
        if (tables != null && (heading = tables.at(0, 0, 0)) != null) {
            try {
                Fixture fixture = this.getLinkedFixtureWithArgs(tables);
                fixture.listener = this.listener;
                fixture.interpretTables(tables);
            }
            catch (Throwable e) {
                this.exception(heading, e);
                this.interpretFollowingTables(tables);
            }
        }
        this.listener.tablesFinished(this.counts);
        Fixture.ClearSymbols();
        SemaphoreFixture.ClearSemaphores();
    }

    public static void ClearSymbols() {
        symbols.clear();
    }

    protected void interpretTables(Parse tables) {
        try {
            this.getArgsForTable(tables);
            this.doTable(tables);
        }
        catch (Exception ex) {
            this.exception(tables.at(0, 0, 0), ex);
            this.listener.tableFinished(tables);
            return;
        }
        this.interpretFollowingTables(tables);
    }

    private void interpretFollowingTables(Parse tables) {
        this.listener.tableFinished(tables);
        tables = tables.more;
        while (tables != null) {
            Parse heading = tables.at(0, 0, 0);
            if (forcedAbort) {
                this.ignore(heading);
            } else if (heading != null) {
                try {
                    Fixture fixture = this.getLinkedFixtureWithArgs(tables);
                    fixture.doTable(tables);
                }
                catch (Throwable e) {
                    this.exception(heading, e);
                }
            }
            this.listener.tableFinished(tables);
            tables = tables.more;
        }
    }

    protected Fixture getLinkedFixtureWithArgs(Parse tables) throws Throwable {
        Parse header = tables.at(0, 0, 0);
        Fixture fixture = Fixture.loadFixture(header.text());
        fixture.counts = this.counts;
        fixture.summary = this.summary;
        fixture.getArgsForTable(tables);
        return fixture;
    }

    public static Fixture loadFixture(String fixtureName) throws Throwable {
        return FixtureLoader.instance().disgraceThenLoad(fixtureName);
    }

    public void getArgsForTable(Parse table) {
        ArrayList<String> argumentList = new ArrayList<String>();
        Parse parameters = table.parts.parts.more;
        while (parameters != null) {
            argumentList.add(Parse.unescape(parameters.body));
            parameters = parameters.more;
        }
        this.args = argumentList.toArray(new String[argumentList.size()]);
    }

    public void doTable(Parse table) {
        this.doRows(table.parts.more);
    }

    public void doRows(Parse rows) {
        while (rows != null) {
            Parse more = rows.more;
            this.doRow(rows);
            rows = more;
        }
    }

    public void doRow(Parse row) {
        this.doCells(row.parts);
    }

    public void doCells(Parse cells) {
        int i = 0;
        while (cells != null) {
            try {
                this.doCell(cells, i);
            }
            catch (Exception e) {
                this.exception(cells, e);
            }
            cells = cells.more;
            ++i;
        }
    }

    public void doCell(Parse cell, int columnNumber) {
        this.ignore(cell);
    }

    public void right(Parse cell) {
        cell.addToTag(" class=\"pass\"");
        ++this.counts.right;
    }

    public void wrong(Parse cell) {
        cell.addToTag(" class=\"fail\"");
        ++this.counts.wrong;
    }

    public void wrong(Parse cell, String actual) {
        this.wrong(cell);
        cell.addToBody(Fixture.label("expected") + "<hr>" + Fixture.escape(actual) + Fixture.label("actual"));
    }

    public void ignore(Parse cell) {
        cell.addToTag(" class=\"ignore\"");
        ++this.counts.ignores;
    }

    public void exception(Parse cell, Throwable exception) {
        while (exception.getClass().equals(InvocationTargetException.class)) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        if (this.isFriendlyException(exception)) {
            cell.addToBody("<hr/>" + Fixture.label(exception.getMessage()));
        } else {
            StringWriter buf = new StringWriter();
            exception.printStackTrace(new PrintWriter(buf));
            cell.addToBody("<hr><pre><div class=\"fit_stacktrace\">" + buf.toString() + "</div></pre>");
        }
        cell.addToTag(" class=\"error\"");
        ++this.counts.exceptions;
    }

    public boolean isFriendlyException(Throwable exception) {
        return exception instanceof FitFailureException;
    }

    public String counts() {
        return this.counts.toString();
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public static String gray(String string) {
        return " <span class=\"fit_grey\">" + string + "</span>";
    }

    public static String escape(String string) {
        return Fixture.escape(Fixture.escape(string, '&', "&amp;"), '<', "&lt;");
    }

    public static String escape(String string, char from, String to) {
        int i = -1;
        while ((i = string.indexOf(from, i + 1)) >= 0) {
            if (i == 0) {
                string = to + string.substring(1);
                continue;
            }
            if (i == string.length()) {
                string = string.substring(0, i) + to;
                continue;
            }
            string = string.substring(0, i) + to + string.substring(i + 1);
        }
        return string;
    }

    public static String camel(String name) {
        StringBuffer b = new StringBuffer(name.length());
        StringTokenizer t = new StringTokenizer(name);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public Object parse(String s, Class<?> type) throws Exception {
        if (type.equals(String.class)) {
            if ("null".equalsIgnoreCase(s)) {
                return null;
            }
            if ("blank".equalsIgnoreCase(s)) {
                return "";
            }
            return s;
        }
        if (type.equals(Date.class)) {
            return DateFormat.getDateInstance(3).parse(s);
        }
        if (Fixture.hasParseMethod(type)) {
            return Fixture.callParseMethod(type, s);
        }
        throw new CouldNotParseFitFailureException(s, type.getName());
    }

    public void check(Parse cell, TypeAdapter a) {
        String text = cell.text();
        if (text.equals("")) {
            this.handleBlankCell(cell, a);
        } else if (a == null) {
            this.ignore(cell);
        } else if (text.equals("error")) {
            this.handleErrorInCell(a, cell);
        } else {
            this.compareCellToResult(a, cell);
        }
    }

    private void compareCellToResult(TypeAdapter a, Parse cell) {
        new CellComparator().compareCellToResult(a, cell);
    }

    public void handleBlankCell(Parse cell, TypeAdapter a) {
        try {
            cell.addToBody(Fixture.gray(a.toString(a.get())));
        }
        catch (Exception e) {
            cell.addToBody(Fixture.gray("error"));
        }
    }

    private void handleErrorInCell(TypeAdapter a, Parse cell) {
        try {
            Object result = a.invoke();
            this.wrong(cell, a.toString(result));
        }
        catch (IllegalAccessException e) {
            this.exception(cell, e);
        }
        catch (Exception e) {
            this.right(cell);
        }
    }

    public String[] getArgs() {
        return Arrays.copyOf(this.args, this.args.length);
    }

    public static void setSymbol(String name, Object value) {
        symbols.put(name, value == null ? "null" : value);
    }

    public static Object getSymbol(String name) {
        return symbols.get(name);
    }

    public static boolean hasSymbol(String name) {
        return symbols.containsKey(name);
    }

    public static boolean hasParseMethod(Class<?> type) {
        try {
            type.getMethod("parse", String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Object callParseMethod(Class<?> type, String s) throws Exception {
        Method parseMethod = type.getMethod("parse", String.class);
        Object o = parseMethod.invoke(null, s);
        return o;
    }

    private class Unparseable {
        private Unparseable() {
        }
    }

    private class CellComparator {
        private Object result = null;
        private Object expected = null;
        private TypeAdapter typeAdapter;
        private Parse cell;

        private CellComparator() {
        }

        private void compareCellToResult(TypeAdapter a, Parse theCell) {
            this.typeAdapter = a;
            this.cell = theCell;
            try {
                this.result = this.typeAdapter.get();
                this.expected = this.parseCell();
                if (this.expected instanceof Unparseable) {
                    this.tryRelationalMatch();
                } else {
                    this.compare();
                }
            }
            catch (Exception e) {
                Fixture.this.exception(this.cell, e);
            }
        }

        private void compare() {
            if (this.typeAdapter.equals(this.expected, this.result)) {
                Fixture.this.right(this.cell);
            } else {
                Fixture.this.wrong(this.cell, this.typeAdapter.toString(this.result));
            }
        }

        private Object parseCell() {
            try {
                return this.typeAdapter.isRegex ? this.cell.text() : this.typeAdapter.parse(this.cell.text());
            }
            catch (NumberFormatException e) {
            }
            catch (ParseException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new Unparseable();
        }

        private void tryRelationalMatch() {
            Class<?> adapterType = this.typeAdapter.type;
            CouldNotParseFitFailureException cantParseException = new CouldNotParseFitFailureException(this.cell.text(), adapterType.getName());
            if (this.result != null) {
                FitMatcher matcher = new FitMatcher(this.cell.text(), this.result);
                try {
                    if (matcher.matches()) {
                        Fixture.this.right(this.cell);
                    } else {
                        Fixture.this.wrong(this.cell);
                    }
                    this.cell.body = matcher.message();
                }
                catch (FitMatcherException fme) {
                    Fixture.this.exception(this.cell, cantParseException);
                }
                catch (Exception e) {
                    Fixture.this.exception(this.cell, e);
                }
            } else {
                Fixture.this.exception(this.cell, cantParseException);
            }
        }
    }

    public class RunTime {
        long start = System.currentTimeMillis();
        long elapsed = 0L;

        public String toString() {
            this.elapsed = System.currentTimeMillis() - this.start;
            if (this.elapsed > 600000L) {
                return this.d(3600000L) + ":" + this.d(600000L) + this.d(60000L) + ":" + this.d(10000L) + this.d(1000L);
            }
            return this.d(60000L) + ":" + this.d(10000L) + this.d(1000L) + "." + this.d(100L) + this.d(10L);
        }

        String d(long scale) {
            long report = this.elapsed / scale;
            this.elapsed -= report * scale;
            return Long.toString(report);
        }
    }
}

