/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.util.TopologyUUID;

public class CanBeSiteMasterTopology
extends TopologyUUID {
    private static final long serialVersionUID = 4261548538335553258L;
    protected boolean can_become_site_master;

    public CanBeSiteMasterTopology() {
    }

    protected CanBeSiteMasterTopology(TopologyUUID uuid, boolean can_become_site_master) {
        super(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), uuid.getSiteId(), uuid.getRackId(), uuid.getMachineId());
        this.can_become_site_master = can_become_site_master;
    }

    public boolean canBecomeSiteMaster() {
        return this.can_become_site_master;
    }

    @Override
    public int size() {
        return super.size() + 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.can_become_site_master = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.can_become_site_master);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        out.writeBoolean(this.can_become_site_master);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.can_become_site_master = in.readBoolean();
    }

    @Override
    public String toString() {
        if (print_uuids) {
            return this.toStringLong() + (this.can_become_site_master ? "[T]" : "[F]");
        }
        return super.toString() + (this.can_become_site_master ? "[T]" : "[F]");
    }
}

