/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.AlreadyImportedException;
import com.xebialabs.xltest.domain.CannotRewriteHistoryException;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.NothingToImportException;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.service.EventRepository;
import com.xebialabs.xltest.service.ExecutableAlreadyRunningException;
import com.xebialabs.xltest.service.Importer;
import com.xebialabs.xltest.service.TestExecutionStateHolder;
import com.xebialabs.xltest.service.TestSpecificationExecutionException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecificationExecutor.class);
    private final ExecutorService executorService;
    private final TestRunsRepository testRunsRepository;
    private final Importer importer;
    private final EventRepository eventRepository;
    private final AutowireCapableBeanFactory beanFactory;
    private final TestExecutionStateHolder testExecutionStateHolder;

    @Autowired
    public TestSpecificationExecutor(ExecutorService executorService, TestRunsRepository testRunsRepository, EventRepository eventRepository, Importer importer, AutowireCapableBeanFactory beanFactory, TestExecutionStateHolder testExecutionStateHolder) {
        this.executorService = executorService;
        this.testRunsRepository = testRunsRepository;
        this.eventRepository = eventRepository;
        this.importer = importer;
        this.beanFactory = beanFactory;
        this.testExecutionStateHolder = testExecutionStateHolder;
    }

    public UUID execute(Executable executable, Map<String, Object> parameters) throws Exception {
        return this.execute(executable, parameters, null);
    }

    public UUID importAllAvailableResults(final ActiveTestSpecification testSpecification) throws ImportException {
        UUID testRunId = UUID.randomUUID();
        final String testSpecificationName = testSpecification.getName();
        this.testExecutionStateHolder.newTestRun(testSpecificationName, testRunId);
        Future<String> task = this.executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateStartTime(testSpecificationName);
                    TestSpecificationExecutor.this.importer.importAllAvailableResults(testSpecification, testSpecification.getRemotePath(), TestSpecificationExecutor.this.getEventHandler(testSpecificationName), new Importer.ImportProgressCallback(){

                        @Override
                        public void update(int percentage) {
                        }
                    });
                }
                catch (AlreadyImportedException | NothingToImportException e) {
                    throw e;
                }
                catch (CannotRewriteHistoryException e) {
                    LOG.error("Error while importing the test specification {}", (Object)testSpecificationName, (Object)e);
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateQualification(testSpecificationName, false, e.getMessage());
                    throw e;
                }
                catch (ImportException e) {
                    LOG.error("Error while importing the test specification {}", (Object)testSpecificationName, (Object)e);
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateQualification(testSpecificationName, false, e.getMessage());
                    throw new TestSpecificationExecutionException(testSpecificationName, "Error while importing the test specification " + testSpecificationName, e);
                }
                catch (Exception e) {
                    LOG.error("Error while importing the test specification {}", (Object)testSpecificationName, (Object)e);
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateQualification(testSpecificationName, false, e.getMessage());
                    throw new TestSpecificationExecutionException(testSpecificationName, "Error while importing the test specification " + testSpecificationName, e);
                }
                finally {
                    LOG.info("removing running task from local memory for specification {}", (Object)testSpecificationName);
                    TestSpecificationExecutor.this.testExecutionStateHolder.moveTaskToExpiredCache(testSpecificationName);
                }
                return testSpecificationName;
            }
        });
        LOG.info("putting taskContext for test specification {} in local memory", (Object)testSpecificationName);
        this.testExecutionStateHolder.updateTask(testSpecificationName, task);
        return testRunId;
    }

    private UUID execute(Executable baseTestSpec, Map<String, Object> parameters, CountDownLatch parentLatch) throws Exception {
        UUID testRunId = UUID.randomUUID();
        this.verifyNotExecutingAlready(baseTestSpec);
        if (baseTestSpec instanceof TestSpecificationSet) {
            this.executeChildrenRecursively((TestSpecificationSet)baseTestSpec, parameters, testRunId, parentLatch);
        } else {
            this.executeSingleSpec(baseTestSpec, parameters, testRunId, parentLatch, this.getEventHandler(new String[0]));
        }
        return testRunId;
    }

    private void executeChildrenRecursively(TestSpecificationSet parentTestSpecification, Map<String, Object> parameters, UUID testRunId, CountDownLatch parentLatch) throws Exception {
        CountDownLatch childCountDownLatch = new CountDownLatch(parentTestSpecification.getExecutableSpecifications().size());
        EventHandler parentEventHandler = this.getEventHandler(new String[0]);
        parentEventHandler.onReceive(this.parentStartEvent(testRunId, parentTestSpecification.getName()));
        this.testExecutionStateHolder.newTestRun(parentTestSpecification.getName(), testRunId);
        for (Executable childTestSpecification : parentTestSpecification.getExecutableSpecifications()) {
            if (childTestSpecification instanceof TestSpecificationSet) {
                this.execute(childTestSpecification, parameters, childCountDownLatch);
                continue;
            }
            if (!(childTestSpecification instanceof Executable)) continue;
            UUID childRunId = UUID.randomUUID();
            this.beanFactory.autowireBean((Object)childTestSpecification);
            EventHandler eventHandler = this.getEventHandler(parentTestSpecification.getName());
            eventHandler.onReceive(this.childStartEvent(testRunId, childTestSpecification.getName(), childRunId));
            this.executeSingleSpec(childTestSpecification, parameters, childRunId, childCountDownLatch, eventHandler);
            eventHandler.onReceive(this.childFinishedEvent(childRunId, childTestSpecification.getName(), childRunId));
        }
        new WaitingParentThread(testRunId, parentTestSpecification.getName(), parentEventHandler, childCountDownLatch, parentLatch).start();
    }

    private void executeSingleSpec(final Executable executable, final Map<String, Object> parameters, final UUID testRunId, final CountDownLatch latch, final EventHandler parentEventHandler) {
        final String testSpecificationName = executable.getName();
        this.testExecutionStateHolder.newTestRun(testSpecificationName, testRunId);
        Future<String> task = this.executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    TestSpecificationExecutor.this.testExecutionStateHolder.updateStartTime(testSpecificationName);
                    LOG.debug("Calling execute on task specification {}", (Object)testSpecificationName);
                    executable.execute(testRunId, parameters, parentEventHandler);
                    if (latch != null) {
                        latch.countDown();
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error while executing the test specification {}", (Object)testSpecificationName, (Object)t);
                    throw new TestSpecificationExecutionException(testSpecificationName, "Error while executing the test specification " + testSpecificationName, t);
                }
                finally {
                    LOG.info("removing running task from local memory for specification {}", (Object)testSpecificationName);
                    TestSpecificationExecutor.this.testExecutionStateHolder.moveTaskToExpiredCache(testSpecificationName);
                }
                return testSpecificationName;
            }
        });
        LOG.info("putting taskContext for test specification {} in local memory", (Object)testSpecificationName);
        this.testExecutionStateHolder.updateTask(testSpecificationName, task);
    }

    protected EventHandler getEventHandler(final String ... testSpecifications) {
        return new EventHandler(){

            public void onReceive(Event event) throws Exception {
                Event latestImportStartedEvent = TestSpecificationExecutor.this.eventRepository.fetchLatest(event.getTestSpecification(), "importStarted");
                TestSpecificationExecutor.checkNewEventIsModifiedAfterLatestExistingEvent(event, latestImportStartedEvent);
                TestSpecificationExecutor.this.eventRepository.insert(event);
                TestSpecificationExecutor.this.notifyExecutingRunCache(event, testSpecifications);
            }
        };
    }

    private void notifyExecutingRunCache(Event event, String[] testSpecifications) {
        if (event.getType().equals("executionStarted")) {
            this.testExecutionStateHolder.syncIfNeeded((String)event.get("testSpecification"));
            this.testExecutionStateHolder.syncIfNeeded(testSpecifications);
        }
        if (event.getType().equals("qualificationComputed")) {
            String failureReason = "";
            if (event.hasProperty("failureReason")) {
                failureReason = (String)event.get("failureReason");
            }
            boolean qualification = (Boolean)event.get("qualification");
            this.testExecutionStateHolder.updateQualification((String)event.get("testSpecification"), qualification, failureReason);
            LOG.debug("Updating qualification of the executed test specification {} run to :", event.get("testSpecification"), (Object)qualification);
        }
    }

    private void verifyNotExecutingAlready(Executable baseTestSpec) {
        if (baseTestSpec instanceof TestSpecificationSet) {
            try {
                for (Executable child : ((TestSpecificationSet)baseTestSpec).getExecutableSpecifications()) {
                    if (child instanceof TestSpecificationSet) {
                        this.verifyNotExecutingAlready(child);
                        continue;
                    }
                    this.checkSpecificationRunning(child.getName());
                }
            }
            catch (ExecutableAlreadyRunningException e) {
                throw new ExecutableAlreadyRunningException(baseTestSpec.getName(), "Can't execute " + baseTestSpec.getName() + " since one of its children " + e.getSpecificationName() + " is already running");
            }
        } else {
            this.checkSpecificationRunning(baseTestSpec.getName());
        }
    }

    private void checkSpecificationRunning(String specificationName) {
        if (this.testExecutionStateHolder.getFromRunningCache(specificationName) != null) {
            throw new ExecutableAlreadyRunningException(specificationName, "Can't execute test specification " + specificationName + " as it is already running");
        }
    }

    public void cancel(String testSpecificationName) {
        if (this.testExecutionStateHolder.getFromRunningCache(testSpecificationName) == null) {
            LOG.warn("Can't cancel the tasks since can't find any running tasks for specification {}", (Object)testSpecificationName);
            return;
        }
        Future<String> task = this.testExecutionStateHolder.getFromRunningCache(testSpecificationName).getTask();
        if (task != null && !task.isDone()) {
            boolean result = task.cancel(true);
            LOG.info("Requested to cancel test run for {} => {}", (Object)testSpecificationName, (Object)result);
        }
    }

    private Event childFinishedEvent(UUID testRunId, String specification, UUID childRunId) {
        return new Event(testRunId, "childFinished", Event.props((Object[])new Object[]{"childRunId", childRunId.toString(), "testSpecification", specification}));
    }

    private Event childStartEvent(UUID testRunId, String specification, UUID childRunId) {
        return new Event(testRunId, "childStarted", Event.props((Object[])new Object[]{"childRunId", childRunId.toString(), "testSpecification", specification}));
    }

    private Event parentFinishedEvent(UUID testRunId, String specification) {
        return new Event(testRunId, "executionFinished", Event.props((Object[])new Object[]{"testSpecification", specification}));
    }

    private Event parentStartEvent(UUID testRunId, String specification) {
        return new Event(testRunId, "executionStarted", Event.props((Object[])new Object[]{"testSpecification", specification}));
    }

    public static void checkNewEventIsModifiedAfterLatestExistingEvent(Event event, Event latestImportStartedEvent) throws CannotRewriteHistoryException {
        if (latestImportStartedEvent != null && latestImportStartedEvent.getType().equals(event.getType()) && event.getLastModified() < latestImportStartedEvent.getLastModified()) {
            throw new CannotRewriteHistoryException(event, latestImportStartedEvent);
        }
    }

    private class WaitingParentThread
    extends Thread {
        private final UUID testRunId;
        private final String specificationName;
        private final EventHandler parentEventHandler;
        private final CountDownLatch countDownLatch;
        private CountDownLatch parentCountDownLatch;

        public WaitingParentThread(UUID testRunId, String name, EventHandler parentEventHandler, CountDownLatch countDownLatch, CountDownLatch parentCountDownLatch) {
            this.testRunId = testRunId;
            this.specificationName = name;
            this.parentEventHandler = parentEventHandler;
            this.countDownLatch = countDownLatch;
            this.parentCountDownLatch = parentCountDownLatch;
        }

        @Override
        public void run() {
            try {
                this.countDownLatch.await();
                this.parentEventHandler.onReceive(TestSpecificationExecutor.this.parentFinishedEvent(this.testRunId, this.specificationName));
                TestSpecificationExecutor.this.testExecutionStateHolder.moveTaskToExpiredCache(this.specificationName);
                if (this.parentCountDownLatch != null) {
                    this.parentCountDownLatch.countDown();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

