/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import com.xebialabs.xltest.view.ListOfEvents;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

public class ListOfEventsWriter
extends BasicMessageBodyWriter<ListOfEvents> {
    public final boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    protected void writeJson(ListOfEvents events, JSONWriter writer) throws JSONException {
        writer.array();
        for (Event event : events) {
            this.writeJson(event, writer);
        }
        writer.endArray();
    }

    @Override
    protected void writeJson(Event event, JSONWriter writer) throws JSONException {
        this.map(writer, event.getProperties());
    }

    private void map(JSONWriter writer, Map<String, Object> properties) throws JSONException {
        writer.object();
        for (Map.Entry<String, Object> p : properties.entrySet()) {
            this.value(writer.key(p.getKey()), p.getValue());
        }
        writer.endObject();
    }

    private void list(JSONWriter writer, Collection<Object> collection) throws JSONException {
        writer.array();
        for (Object value : collection) {
            this.value(writer, value);
        }
        writer.endArray();
    }

    private void value(JSONWriter writer, Object value) throws JSONException {
        if (value instanceof Collection) {
            this.list(writer, (Collection)value);
        } else if (value instanceof Map) {
            this.map(writer, (Map)value);
        } else {
            writer.value(value);
        }
    }

    @Override
    public String toJson(Event event) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter((Writer)stringWriter);
        this.writeJson(event, writer);
        return stringWriter.toString();
    }
}

