/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
public class CiJsonMessageBodyReader
implements MessageBodyReader<ConfigurationItem> {
    private Repository repository;
    private static final Logger LOG = LoggerFactory.getLogger(CiJsonMessageBodyReader.class);

    @Autowired
    public CiJsonMessageBodyReader(Repository repository) {
        this.repository = repository;
    }

    public boolean isReadable(Class<?> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public ConfigurationItem readFrom(Class<ConfigurationItem> type, java.lang.reflect.Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ConfigurationItem result;
        CiJsonReader reader;
        JSONObject json;
        ConfigurationItemConverter converter = new ConfigurationItemConverter();
        String jsonAsString = "";
        try {
            jsonAsString = CiJsonMessageBodyReader.extractJsonMapString(new InputStreamReader(entityStream, StandardCharsets.UTF_8));
            json = new JSONObject(jsonAsString);
            this.discardUnknownProperties(json);
            reader = new CiJsonReader(json);
        }
        catch (JSONException e) {
            LOG.error("Unable to parse:\n" + jsonAsString);
            LOG.error("Exception is : ", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        try {
            result = converter.readCi((CiReader)reader);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Conversion error. Can't handle mapping this json: " + json + " to a CI");
            throw new IllegalArgumentException(e);
        }
        converter.resolveReferences(this.repository);
        return result;
    }

    public static String extractJsonMapString(Reader reader) throws IOException {
        int openBrace = 1;
        boolean quote = false;
        boolean backslash = false;
        int i = reader.read();
        char c = (char)i;
        StringBuffer buffer = new StringBuffer();
        if (c != '{') {
            throw new IllegalArgumentException("Expecting '{' in json map");
        }
        buffer.append(c);
        do {
            if ((i = reader.read()) == -1) {
                throw new IllegalArgumentException("Unexpected end of stream");
            }
            c = (char)i;
            buffer.append(c);
            if (backslash) {
                backslash = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    quote = !quote;
                    break;
                }
                case '{': {
                    if (quote) break;
                    ++openBrace;
                    break;
                }
                case '}': {
                    if (quote) break;
                    --openBrace;
                    break;
                }
                case '\\': {
                    backslash = true;
                }
            }
        } while (openBrace > 0 && i != -1);
        return buffer.toString();
    }

    private void discardUnknownProperties(JSONObject json) {
        try {
            if (json.has("type")) {
                Type type = Type.valueOf((String)json.getString("type"));
                final Collection validPropertyNames = Collections2.transform((Collection)type.getDescriptor().getPropertyDescriptors(), (Function)new Function<PropertyDescriptor, String>(){

                    public String apply(PropertyDescriptor propertyDescriptor) {
                        return propertyDescriptor.getName();
                    }
                });
                Collection unknownKeys = Collections2.filter((Collection)Lists.newArrayList((Iterator)json.keys()), (Predicate)new Predicate<String>(){

                    public boolean apply(String jsonKey) {
                        return !jsonKey.equals("id") && !jsonKey.equals("type") && !jsonKey.startsWith("$") && !validPropertyNames.contains(jsonKey);
                    }
                });
                for (String unknownKey : unknownKeys) {
                    LOG.warn("Unknown property [{}] found in type [{}]. It will be discarded before saving the CI!", (Object)unknownKey, (Object)type);
                    json.remove(unknownKey);
                }
            }
        }
        catch (JSONException e) {
            LOG.error("Exception while discarding unknown properties", (Throwable)e);
        }
    }
}

