/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true, description="Base type for configuration items using Jython scripts.", versioned=false)
public class ScriptedConfigurationItem
extends BaseConfigurationItem {
    @Property(description="location of the script on the class path.", required=false)
    private String scriptLocation;
    private static final Logger LOG = LoggerFactory.getLogger(ScriptedConfigurationItem.class);

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(ScriptContext scriptContext, BaseConfigurationItem invoker) throws ScriptExecutionException, FileNotFoundException {
        LogWriter executionLog = new LogWriter(this.getType().toString());
        ResultHolder resultHolder = new ResultHolder();
        scriptContext.setAttribute("resultHolder", resultHolder, 100);
        ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
        if (executor == null) {
            throw new IllegalStateException("Script execution has not been initialized");
        }
        scriptContext.setWriter(executionLog);
        scriptContext.setErrorWriter(executionLog);
        try {
            executor.evalScriptedCi((ConfigurationItem)invoker, scriptContext);
        }
        finally {
            LOG.trace("{}: Script executed, result: {}", (Object)this.getType().toString(), resultHolder.result);
            try {
                ((Writer)executionLog).close();
            }
            catch (IOException e) {}
        }
        return (T)resultHolder.result;
    }

    protected ScriptContext newScriptContext() {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setAttribute("self", (Object)this, 100);
        return context;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("scriptLocation", (Object)this.scriptLocation).toString();
    }

    public static class LogWriter
    extends Writer {
        private final Logger log;
        private final StringBuilder buffer;

        public LogWriter(String type) {
            this.log = LoggerFactory.getLogger((String)type);
            this.buffer = new StringBuilder(512);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                char c = cbuf[i];
                if (c == '\n' || c == '\r') {
                    this.log();
                    continue;
                }
                this.buffer.append(c);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            this.log();
        }

        private void log() {
            if (this.buffer.length() > 0) {
                this.log.info(this.buffer.toString());
                this.buffer.delete(0, this.buffer.length());
            }
        }
    }

    public static class ProcessHolder<T> {
        private T process;

        public void setProcess(T process) {
            this.process = process;
        }

        public T getProcess() {
            return this.process;
        }
    }

    public static class ResultHolder<T> {
        private T result;

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }
}

