/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.xltest.domain.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class QualificationResult {
    private final Result result;
    private final DateTime time;
    private final List<String> failureReason;
    private final Map<String, Object> otherProperties;

    public static QualificationResult notFound() {
        return new QualificationResult(Result.NOT_FOUND, new DateTime(0L), Collections.emptyList());
    }

    public QualificationResult(Result result, DateTime time, String failureReason) {
        this(result, time, failureReason, Collections.emptyMap());
    }

    public QualificationResult(Result result, DateTime time, List<String> failureReason) {
        this.result = result;
        this.time = time;
        this.failureReason = Collections.unmodifiableList(failureReason);
        this.otherProperties = Collections.emptyMap();
    }

    public QualificationResult(Result result, DateTime time, String failureReason, Map<String, Object> properties) {
        this.result = result;
        this.time = time;
        this.failureReason = Collections.singletonList(failureReason);
        this.otherProperties = Collections.unmodifiableMap(properties);
    }

    public static QualificationResult merge(QualificationResult a, QualificationResult b) {
        Result tmpResult = QualificationResult.resolve(a.getResult(), b.getResult());
        ArrayList failureReasons = Lists.newArrayList(a.failureReason);
        failureReasons.addAll(b.failureReason);
        DateTime tmpTime = a.time.isAfter((ReadableInstant)b.time) ? a.time : b.time;
        return new QualificationResult(tmpResult, tmpTime, failureReasons);
    }

    public static QualificationResult fromEvents(Collection<Event> events) {
        Result tmpResult = Result.NOT_FOUND;
        DateTime tmpTime = new DateTime();
        ArrayList tmpFailureReasons = Lists.newArrayList();
        for (Event event : events) {
            if (event == null || event.get("qualification") == null) continue;
            if (((Boolean)event.get("qualification")).booleanValue()) {
                if (tmpResult == Result.FAILED) continue;
                tmpResult = Result.PASSED;
                continue;
            }
            if (((Boolean)event.get("qualification")).booleanValue()) continue;
            tmpResult = Result.FAILED;
            tmpFailureReasons.add((String)event.get("failureReason"));
        }
        return new QualificationResult(tmpResult, tmpTime, tmpFailureReasons);
    }

    public static QualificationResult fromEvent(Event event) {
        return QualificationResult.fromEvents(Collections.singletonList(event));
    }

    public QualificationResult add(QualificationResult other) {
        if (this.result == Result.FAILED && other.result != Result.FAILED) {
            return this;
        }
        if (this.result != Result.FAILED && other.result == Result.FAILED) {
            return other;
        }
        if (this.result == Result.NOT_FOUND && other.result == Result.PASSED) {
            return other;
        }
        return this;
    }

    public DateTime getTime() {
        return this.time;
    }

    public String getFailureReason() {
        return this.failureReason.isEmpty() ? "" : this.failureReason.get(this.failureReason.size() - 1);
    }

    public boolean getQualification() {
        return this.result == Result.PASSED;
    }

    public Result getResult() {
        return this.result;
    }

    public Map<String, Object> getOtherProperties() {
        return this.otherProperties;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("result", (Object)this.result).add("failureReason", this.failureReason).add("time", (Object)this.time).add("otherProperties", this.otherProperties).toString();
    }

    public static Result resolve(Result a, Result b) {
        if (a == Result.FAILED || b == Result.FAILED) {
            return Result.FAILED;
        }
        if (a == Result.NOT_FOUND || b == Result.NOT_FOUND) {
            return Result.NOT_FOUND;
        }
        return Result.PASSED;
    }

    public static enum Result {
        PASSED(0),
        FAILED(2),
        NOT_FOUND(1);

        public final int value;

        private Result(int value) {
            this.value = value;
        }
    }
}

