/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Executable;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.Importer;
import com.xebialabs.xltest.view.ExecutionParameterRequest;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Metadata(label="Executable Test Specification", description="A test specification that can execute test runs.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class ExecutableTestSpecification
extends ActiveTestSpecification
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableTestSpecification.class);
    @Property(description="Command to execute this test set.", category="Execution")
    private String commandLine;
    @Property(description="Maximum number of minutes this test set is allowed to execute.", required=true, category="Execution", defaultValue="10")
    private Integer timeout;
    @Property(description="Location of the script on the class path.", required=false, defaultValue="", hidden=true)
    private String scriptLocation;
    @Autowired
    private transient TestToolRepository testToolRepository;
    @Autowired
    private transient ExecutorService executorService;
    @Autowired
    private transient TestRunsRepository testRunsRepository;
    @Autowired
    private transient Importer importer;

    @Override
    public void execute(UUID testRunId, Map<String, Object> parameters, final EventHandler eventHandler) throws ImportException {
        TestTool testTool = this.testToolRepository.findByName(this.getTestToolName());
        String resolvedCommandline = this.resolve(this.getCommandLine(), parameters);
        this.execute(testRunId, this.executorService, testTool, resolvedCommandline, parameters, new EventHandler(){

            public void onReceive(Event event) throws Exception {
                eventHandler.onReceive(new Event(event, Event.props((Object[])new Object[]{"testSpecification", ExecutableTestSpecification.this.getName()})));
            }
        });
        this.importer.importLatestResults(this, testRunId, this.getRemotePath(), new EventHandler(){

            public void onReceive(Event event) throws Exception {
                eventHandler.onReceive(event);
            }
        });
    }

    @Override
    public boolean updateExecutionProperties(String commandLine, Host host) {
        if (host != null) {
            LOG.debug("Updating host to {}", (Object)host);
            this.setHost(host);
        }
        if (commandLine != null) {
            LOG.debug("Updating commandline to {}", (Object)commandLine);
            this.commandLine = commandLine;
        }
        return this.isExecutable();
    }

    @Override
    public ExecutionParameterRequest toExecutionParameterRequest() {
        return new ExecutionParameterRequest(this.commandLine, this.getHost() != null ? this.getHost().getId() : null, this.getParameters());
    }

    private Map<String, Set<String>> getParameters() {
        HashMap<String, Set<String>> parameterMap = new HashMap<String, Set<String>>();
        Collection propertyDescriptors = this.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!"Parameters".equalsIgnoreCase(propertyDescriptor.getCategory())) continue;
            String key = propertyDescriptor.getName();
            String value = (String)propertyDescriptor.get((ConfigurationItem)this);
            parameterMap.put(key, Sets.newHashSet((Object[])new String[]{value}));
        }
        return parameterMap;
    }

    private Qualifier getQualifierIfAny(UUID testRunId) {
        if (this.getQualification() == null) {
            return null;
        }
        return this.getQualification().getQualifier(testRunId, this.testRunsRepository);
    }

    protected void execute(UUID testRunId, ExecutorService executorService, TestTool testTool, String resolvedCommandline, Map<String, Object> parameters, EventHandler eventHandler) {
        SimpleBindings binding = new SimpleBindings();
        binding.put("testRunId", (Object)testRunId);
        binding.put("executorService", (Object)executorService);
        binding.put("self", (Object)this);
        binding.put("resolvedCommandLine", (Object)resolvedCommandline);
        binding.put("testTool", (Object)testTool);
        binding.put("eventHandler", (Object)eventHandler);
        binding.put("parameters", (Object)(parameters == null ? new HashMap() : parameters));
        ScriptedConfigurationItem scriptedConfigurationItem = new ScriptedConfigurationItem();
        scriptedConfigurationItem.setScriptLocation(this.scriptLocation);
        ScriptContext context = scriptedConfigurationItem.newScriptContext();
        context.setBindings(binding, 100);
        try {
            scriptedConfigurationItem.execute(context, this);
        }
        catch (ScriptExecutionException e) {
            LOG.error("Unable to execute script", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException("No execution script found", (Throwable)e);
        }
    }

    protected String resolve(String commandLine, Map<String, Object> parameters) {
        if (commandLine == null || commandLine.equals("")) {
            return commandLine;
        }
        Template tmpl = Mustache.compiler().compile(commandLine);
        return tmpl.execute(parameters);
    }

    public static String[] parseCommandLine(String commandLine) {
        if (commandLine == null) {
            return new String[]{""};
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("\"([^\"]*)\"|[\\S]+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group(1) == null ? m.group(0) : m.group(1);
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static boolean isExecutable(String commandLine, Host host) {
        return !Strings.isNullOrEmpty((String)commandLine) && host != null;
    }

    @Override
    public boolean isExecutable() {
        return ExecutableTestSpecification.isExecutable(this.commandLine, this.getHost());
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTestToolRepository(TestToolRepository testToolRepository) {
        this.testToolRepository = testToolRepository;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setTestRunsRepository(TestRunsRepository testRunsRepository) {
        this.testRunsRepository = testRunsRepository;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public CmdLine getCmdLine() {
        return CmdLine.build((String[])ExecutableTestSpecification.parseCommandLine(this.commandLine));
    }

    public CmdLine getCmdLine(String resolvedCommandLine) {
        return CmdLine.build((String[])ExecutableTestSpecification.parseCommandLine(resolvedCommandLine));
    }

    public static ExecutableTestSpecification newInstance(String id) {
        return (ExecutableTestSpecification)Type.valueOf((String)"xlt", (String)ExecutableTestSpecification.class.getSimpleName()).getDescriptor().newInstance(id);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("commandLine", (Object)this.commandLine).add("timeout", (Object)this.timeout).add("scriptLocation", (Object)this.scriptLocation).add("testTools", (Object)this.testToolRepository).add("executorService", (Object)this.executorService).add("testRunsRepository", (Object)this.testRunsRepository).add("importer", (Object)this.importer).toString();
    }
}

