/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.Dashboard;

@Metadata(description="A tile in a dashboard that displays a report.", root=Metadata.ConfigurationItemRoot.NESTED, versioned=false)
public class DashboardTile
extends BaseConfigurationItem {
    @Property(description="The title of the tile that appears in the header.")
    private String title;
    @Property(description="The test specification that supplies the data for the report displayed in the tile.")
    private BaseTestSpecification testSpecification;
    @Property(description="The type of the report displayed in the tile.")
    private String reportType;
    @Property(description="X coordinate of the tile on the 12x12 dashboard grid. 0 is left.")
    private int x;
    @Property(description="Y coordinate of the tile on the 12x12 dashboard grid. 0 is top.")
    private int y;
    @Property(description="Width of the tile on the 12x12 dashboard grid.")
    private int w;
    @Property(description="Height of the tile on the 12x12 dashboard grid.")
    private int h;
    @Property(required=false, description="What level of the test hierarchy is shown. Empty means the top level.")
    private String drillDownPrefix;
    @Property(isTransient=true, required=false, description="Derived from reportType, used for the UI.")
    private String reportIcon;
    @Property(isTransient=true, required=false, description="Derived from reportType, used for the UI.")
    private String reportName;
    @Property(isTransient=true, required=false, description="Does this tile represent demo data?")
    private boolean showCaseData;

    public DashboardTile() {
    }

    public DashboardTile(String id, int x, int y, int w, int h) {
        this.setId(id);
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public DashboardTile copyToDashboard(Dashboard createdDashboard) {
        Preconditions.checkNotNull((Object)((Object)createdDashboard));
        DashboardTile newTile = new DashboardTile(this.id, this.x, this.y, this.w, this.h);
        newTile.id = createdDashboard.getId() + "/" + this.title;
        newTile.title = this.title;
        newTile.testSpecification = this.testSpecification;
        newTile.reportType = this.reportType;
        newTile.reportName = this.reportName;
        newTile.reportIcon = this.reportIcon;
        newTile.type = this.type;
        newTile.drillDownPrefix = this.drillDownPrefix;
        return newTile;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getReportIcon() {
        return this.reportIcon;
    }

    public void setReportIcon(String reportIcon) {
        this.reportIcon = reportIcon;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getDrillDownPrefix() {
        return this.drillDownPrefix;
    }

    public void setDrillDownPrefix(String drillDownPrefix) {
        this.drillDownPrefix = drillDownPrefix;
    }

    public String getReportType() {
        return this.reportType;
    }

    public BaseTestSpecification getTestSpecification() {
        return this.testSpecification;
    }

    public void setTestSpecification(BaseTestSpecification testSpecification) {
        this.testSpecification = testSpecification;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setShowCaseData(boolean showCaseData) {
        this.showCaseData = showCaseData;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("title", (Object)this.title).add("testSpecification", (Object)this.testSpecification).add("reportType", (Object)this.reportType).add("x", this.x).add("y", this.y).add("w", this.w).add("h", this.h).add("drillDownPrefix", (Object)this.drillDownPrefix).add("reportIcon", (Object)this.reportIcon).add("reportName", (Object)this.reportName).add("showCaseData", this.showCaseData).toString();
    }

    public static DashboardTile newInstance(String id) {
        return (DashboardTile)Type.valueOf((String)"xlt", (String)DashboardTile.class.getSimpleName()).getDescriptor().newInstance(id);
    }

    public String getDashboardId() {
        return Synthetic.retrieveDashboardIdFromDashboardTileId(this.getId());
    }
}

