/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.Importable;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTestTool
implements TestTool {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTestTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalFile retrieveFiles(OverthereFile remoteFile) {
        LocalFile tempFolder = null;
        try {
            if (remoteFile instanceof LocalFile) {
                LocalFile localFile = (LocalFile)remoteFile;
                return localFile;
            }
            tempFolder = this.getLocalTempFolder();
            LOG.info("Will copy files from {} to {}", (Object)remoteFile, (Object)tempFolder);
            remoteFile.copyTo((OverthereFile)tempFolder);
            LOG.info("Copied FitNesseRoot to {}", (Object)tempFolder);
            LocalFile localFile = tempFolder;
            return localFile;
        }
        finally {
            if (tempFolder != null) {
                tempFolder.getConnection().close();
            }
        }
    }

    private LocalFile getLocalTempFolder() {
        File tempFile;
        try {
            tempFile = File.createTempFile("xltesttool", "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temp file", e);
        }
        tempFile.delete();
        tempFile.mkdirs();
        LocalConnection localConnection = new LocalConnection("local", new ConnectionOptions());
        return new LocalFile(localConnection, tempFile);
    }

    @Override
    public SortedSet<OverthereFile> findTestResultPaths(OverthereFile searchRoot, FileMatcher fileMatcher) {
        return Globbit.find(searchRoot, fileMatcher, Globbit.GlobMode.FILES_AND_DIRECTORIES);
    }

    @Override
    public Importable findLatestImportable(OverthereFile testResultPath, FileMatcher fileMatcher) throws ImportException {
        ArrayList<Importable> importables = new ArrayList<Importable>(this.findImportables(testResultPath, fileMatcher));
        Collections.sort(importables, new Comparator<Importable>(){

            @Override
            public int compare(Importable importable1, Importable importable2) {
                try {
                    Long lastModified1 = importable1.getTimestamp();
                    Long lastModified2 = importable2.getTimestamp();
                    return lastModified2.compareTo(lastModified1);
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    return 0;
                }
            }
        });
        return importables.size() != 0 ? (Importable)importables.get(0) : null;
    }

    protected final SortedSet<OverthereFile> globFilesAndDirectories(OverthereFile root, FileMatcher matcher) {
        return Globbit.find(root, matcher, Globbit.GlobMode.FILES_AND_DIRECTORIES);
    }

    protected final SortedSet<OverthereFile> globFiles(OverthereFile root, FileMatcher matcher) {
        return Globbit.find(root, matcher, Globbit.GlobMode.FILES_ONLY);
    }
}

