/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.TestToolNameAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="Active Test Specification", description="A test specification that can retrieve test results.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class ActiveTestSpecification
extends BaseTestSpecification
implements TestToolNameAware {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveTestSpecification.class);
    @Property(description="Name of the test tool, such as JMeter, FitNesse or Cucumber.")
    private String testToolName;
    @Property(description="Pattern for matching test result files.")
    private String searchPattern;
    @Property(description="Directory where test results are located after execution completes.")
    private String workingDirectory;
    @Property(description="Host where the test results are located.")
    private Host host;

    @Override
    public String getTestToolName() {
        return this.testToolName;
    }

    @Override
    public void setTestToolName(String testToolName) {
        this.testToolName = testToolName;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public OverthereFile getRemotePath() {
        OverthereConnection hostConnection = this.getHost() != null ? this.getHost().getConnection() : LocalConnection.getLocalConnection();
        return hostConnection.getFile(this.workingDirectory);
    }

    public static ActiveTestSpecification newInstance(String id) {
        return (ActiveTestSpecification)Type.valueOf((String)"xlt", (String)ActiveTestSpecification.class.getSimpleName()).getDescriptor().newInstance(id);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("testToolName", (Object)this.getTestToolName()).add("searchPattern", (Object)this.getSearchPattern()).add("qualificationType", (Object)this.getQualificationType()).toString();
    }
}

