/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.v1;

import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.service.QualificationFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/v1/qualifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class QualificationController {
    private static final Logger LOG = LoggerFactory.getLogger(QualificationController.class);
    public static final String MESSAGE = "message";
    public static final String RESULT = "result";
    private static final String TIME = "time";
    private static final String TYPE = "type";
    private static final String STATUS = "status";
    private final TestSpecificationRepository testSpecificationRepository;
    private final QualificationFinder qualificationFinder;

    @Autowired
    public QualificationController(TestSpecificationRepository testSpecificationRepository, QualificationFinder qualificationFinder) {
        this.testSpecificationRepository = testSpecificationRepository;
        this.qualificationFinder = qualificationFinder;
    }

    @Path(value="/")
    @GET
    public Response getQualificationByName(@QueryParam(value="testSpecification") String testSpecification, @Context UriInfo uriInfo) {
        QualificationResult qualificationResult;
        if (StringUtils.isEmpty((CharSequence)testSpecification)) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put(MESSAGE, "A test specification is required in the testSpecification query parameter");
            result.put(STATUS, "400");
            result.put("error_code", "object.not.found");
            return Response.status((int)400).entity(result).build();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BaseTestSpecification testSpec = this.testSpecificationRepository.get(testSpecification);
        HashMap<String, String> query = new HashMap<String, String>();
        for (String key : uriInfo.getQueryParameters().keySet()) {
            query.put(key, (String)uriInfo.getQueryParameters().getFirst((Object)key));
        }
        if (testSpec instanceof TestSpecificationSet) {
            qualificationResult = this.getQualificationResultForSet(testSpec, query);
        } else {
            query.put("testSpecification", testSpecification);
            qualificationResult = this.qualificationFinder.getFilteredResult(query);
        }
        switch (qualificationResult.getResult()) {
            case PASSED: {
                result.put(RESULT, true);
                result.put(MESSAGE, qualificationResult.getFailureReason());
                result.put(TIME, qualificationResult.getTime().toString());
                return Response.ok(result).build();
            }
            case FAILED: {
                result.put(RESULT, false);
                result.put(MESSAGE, qualificationResult.getFailureReason());
                result.put(TIME, qualificationResult.getTime().toString());
                return Response.ok(result).build();
            }
            case NOT_FOUND: {
                result.put(RESULT, false);
                result.put(MESSAGE, "No results available for this testSpecification");
                result.put("error_code", "no.qualification.results");
                return Response.status((int)404).entity(result).build();
            }
        }
        throw new RuntimeException("Forgot to implement case");
    }

    private QualificationResult getQualificationResultForSet(BaseTestSpecification testSpec, Map<String, String> query) {
        TestSpecificationSet set = (TestSpecificationSet)testSpec;
        ArrayList<QualificationResult> subResults = new ArrayList<QualificationResult>();
        for (BaseTestSpecification bts : set.getTestSpecifications()) {
            query.put("testSpecification", bts.getName());
            subResults.add(this.qualificationFinder.getFilteredResult(query));
        }
        QualificationResult qualificationResult = this.qualificationFinder.getQualificationResult(subResults);
        return qualificationResult;
    }
}

