/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.ActiveTestSpecification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.TestResultLocator;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/testtools")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestToolsController {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolsController.class);
    private final TestToolRepository testToolRepository;
    private final TestSpecificationRepository testSpecifications;

    @Autowired
    public TestToolsController(TestToolRepository testToolRepository, TestSpecificationRepository testSpecifications) {
        this.testToolRepository = testToolRepository;
        this.testSpecifications = testSpecifications;
    }

    @GET
    public Response getTestToolRepository() {
        JSONArray json = new JSONArray();
        for (TestTool testTool : this.testToolRepository.getTestTools()) {
            JSONObject tool = new JSONObject();
            tool.put((Object)"name", (Object)testTool.getName());
            tool.put((Object)"pattern", (Object)testTool.getDefaultSearchPattern());
            json.add((Object)tool);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @GET
    @Path(value="{testTool}/paths")
    public Response validateHostConfiguration(@PathParam(value="testTool") String testTool, @QueryParam(value="type") String type, @QueryParam(value="address") String address, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="path") String path, @QueryParam(value="pattern") String pattern) {
        Collection<OverthereFile> files;
        List<ActiveTestSpecification> testSpecificationsWithHost = this.testSpecifications.findWithHost(testTool, pattern, address, path, -1, type);
        try {
            files = new TestResultLocator(this.testToolRepository).forHost(type, address, username, password).forTestTool(testTool).locate(path, pattern);
        }
        catch (Exception e) {
            LOG.info("Unable to validate host configuration. Type: {}, address: {}, username: {}, path: {}, testtool: {}", new Object[]{type, address, username, path, testTool, e});
            JSONObject json = new JSONObject();
            json.put((Object)"error", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
        if (files != null && !files.isEmpty()) {
            JSONObject json = new JSONObject();
            JSONArray paths = new JSONArray();
            json.put((Object)"paths", (Object)paths);
            for (OverthereFile file : files) {
                paths.add((Object)file.getPath());
            }
            JSONArray testSpecificationsJson = new JSONArray();
            json.put((Object)"testSpecifications", (Object)testSpecificationsJson);
            for (ActiveTestSpecification testSpecification : testSpecificationsWithHost) {
                testSpecificationsJson.add((Object)testSpecification.getName());
            }
            return Response.ok((Object)json.toString()).build();
        }
        JSONObject json = new JSONObject();
        json.put((Object)"error", (Object)String.format("No test results found in path %s", path));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)json.toString()).build();
    }
}

