/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TagsRepository;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.utils.JcrUtils;
import com.xebialabs.xltest.utils.PeriodToDates;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

@Controller
@Path(value="/api/internal/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
public class ReportController {
    private static final Logger LOG = LoggerFactory.getLogger(ReportController.class);
    private final RepositoryService repositoryService;
    private final TagsRepository tagsRepository;
    private final TestRunsRepository testRunsRepository;
    private final AutowireCapableBeanFactory beanFactory;

    @Autowired
    public ReportController(RepositoryService repositoryService, TestRunsRepository testRunsRepository, AutowireCapableBeanFactory beanFactory, TagsRepository tagsRepository) {
        this.repositoryService = repositoryService;
        this.testRunsRepository = testRunsRepository;
        this.beanFactory = beanFactory;
        this.tagsRepository = tagsRepository;
    }

    @GET
    @Path(value="/{reportName}/testspecification/{testSpecificationName:.*}")
    public Response generateReportFromTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationName, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo, @QueryParam(value="date") String date, @QueryParam(value="range") String range) throws IOException {
        DateTime parsedDate = DateTime.now();
        if (StringUtils.hasText((String)date) && !"now".equals(date)) {
            parsedDate = DateTime.parse((String)date);
        }
        PeriodToDates period = new PeriodToDates(parsedDate);
        DateTime startDate = period.getBeginDateOf(range);
        DateTime endDate = period.getEndDateWithTimeEndOfDay();
        TestRun latestTestRun = this.testRunsRepository.getLatestTestRun(JcrUtils.encodeJcrId(testSpecificationName), startDate.getMillis(), endDate.getMillis());
        if (latestTestRun == null) {
            return Response.noContent().build();
        }
        Map<String, Object> resultObject = this.generateReportTheAwesomeWay(latestTestRun, reportName, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), startDate.toDate(), endDate.toDate());
        return Response.ok((Object)JsonProviderFactory.createProvider().toJson(resultObject)).build();
    }

    @GET
    @Path(value="/{reportName}/testrun/{testRunId:.*}")
    public Response generateReportFromTestRun(@PathParam(value="testRunId") String testRunId, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo) throws IOException {
        TestRun testRun = this.testRunsRepository.getTestRun(testRunId);
        if (testRun == null) {
            return Response.noContent().build();
        }
        Map<String, Object> resultObject = this.generateReportTheAwesomeWay(testRun, reportName, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), testRun.getStartTime(), testRun.getFinishedTime());
        return Response.ok((Object)JsonProviderFactory.createProvider().toJson(resultObject)).build();
    }

    @POST
    @Path(value="/{testRunId:.+}")
    public String generateReport(@PathParam(value="testRunId") String testRunId, Report report, @Context UriInfo uriInfo) {
        Map<String, Object> resultObject = this.generateReport(UUID.fromString(testRunId), report, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }

    private Map<String, String> convertMultivaluedMapToMap(MultivaluedMap<String, String> multivaluedMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : multivaluedMap.keySet()) {
            if (((List)multivaluedMap.get((Object)key)).size() == 1) {
                map.put(key, (String)multivaluedMap.getFirst((Object)key));
                continue;
            }
            map.put(key, Joiner.on((String)";").join((Iterable)multivaluedMap.get((Object)key)));
        }
        return map;
    }

    private Map<String, Object> generateReport(UUID testRunId, Report report, Map<String, String> queryParameters) {
        TestRun run = this.testRunsRepository.getTestRun(testRunId);
        return this.generateReport(run, report, queryParameters);
    }

    private Map<String, Object> generateReport(TestRun testRun, Report report, Map<String, String> queryParameters) {
        if (report != null) {
            this.beanFactory.autowireBean((Object)report);
            report.addAttribute("queryParameters", queryParameters);
            report.addAttribute("startDate", this.makeStartDateIfProvided(queryParameters.get("startDate")));
            report.addAttribute("endDate", this.makeEndDateIfProvided(queryParameters.get("endDate")));
            TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
            resultObject.put("type", report.getReportType().toLowerCase());
            resultObject.put("report", report.compute(testRun));
            return resultObject;
        }
        return Collections.emptyMap();
    }

    private Date makeStartDateIfProvided(String dateString) {
        Date result = this.parseDateString(dateString);
        if (result == null) {
            result = new DateTime().minusWeeks(2).withTimeAtStartOfDay().toDate();
        }
        return result;
    }

    private Date makeEndDateIfProvided(String dateString) {
        Date result = this.parseDateString(dateString);
        if (result == null) {
            result = new Date();
        }
        return result;
    }

    private Date parseDateString(String dateString) {
        if (StringUtils.hasText((String)dateString)) {
            try {
                DateTime dateTime = new DateTime(Long.parseLong(dateString));
                return dateTime.withTimeAtStartOfDay().toDate();
            }
            catch (Exception e) {
                LOG.error("Unable to convert dateString (expected to be timestamp) [" + dateString + "] into Date.");
            }
        }
        return null;
    }

    private Map<String, Object> generateReportTheAwesomeWay(TestRun testRun, String reportName, Map<String, String> queryParameters, Date startDate, Date endDate) {
        Report report = (Report)DescriptorRegistry.getDescriptor((String)reportName).newInstance(UUID.randomUUID().toString());
        if (report != null) {
            this.beanFactory.autowireBean((Object)report);
            report.addAttribute("queryParameters", queryParameters);
            report.addAttribute("startDate", startDate);
            report.addAttribute("endDate", endDate);
            if (queryParameters.containsKey("tags")) {
                report.addAttribute("tags", Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)queryParameters.get("tags")));
            } else {
                report.addAttribute("tags", new HashMap());
            }
            TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
            resultObject.put("type", report.getReportType().toLowerCase());
            resultObject.put("report", report.compute(testRun));
            return resultObject;
        }
        return Collections.emptyMap();
    }
}

