/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.google.common.base.Supplier;
import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.xlplatform.repository.RepositoryConfigurationSource;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import com.xebialabs.xltest.AbstractContextConfig;
import com.xebialabs.xltest.XltRepositoryConfig;
import com.xebialabs.xltest.elasticsearch.ElasticSearchClientFactoryBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ComponentScan(value={"com.xebialabs.deployit.service.validation", "com.xebialabs.xlplatform.upgrade", "com.xebialabs.xltest.api", "com.xebialabs.xltest.serialize", "com.xebialabs.xltest.service", "com.xebialabs.xltest.repository"})
@ImportResource(value={"classpath:spring/xltest-context.xml"})
public class ContextConfig
extends AbstractContextConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)ContextConfig.class.getName());

    @Override
    public boolean loadDemoData() {
        return System.getProperty("xlt.load.demo.data", "true").equalsIgnoreCase("true");
    }

    @Override
    public ReleaseInfo releaseInfo() {
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/xltest/release.properties");
        LOG.info("XL TestView version {} (built at {})", (Object)releaseInfo.getVersion(), (Object)releaseInfo.getDate());
        LOG.info("(c) 2013-{} XebiaLabs", (Object)new SimpleDateFormat("yyyy").format(new Date()));
        return releaseInfo;
    }

    @Override
    public XlRepositoryConfig repositoryConfig() {
        RepositoryConfigurationSource repoConfigSource = new RepositoryConfigurationSource("repository.json");
        XltRepositoryConfig cfg = new XltRepositoryConfig("xlt", (Supplier<char[]>)this.serverConfiguration().getAdminPasswordSupplier(), repoConfigSource, this.releaseInfo());
        return cfg;
    }

    @Override
    public ElasticSearchClientFactoryBean getElasticSearchFactory() throws Exception {
        ElasticSearchClientFactoryBean elasticSearchFactory = new ElasticSearchClientFactoryBean();
        elasticSearchFactory.setPathData(this.elasticSearchBaseDir());
        elasticSearchFactory.setHttpEnabled(this.elasticSearchHttpServer());
        elasticSearchFactory.setPortRange(this.elasticSearchPort());
        return elasticSearchFactory;
    }
}

