/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNames;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.PlainTransportFuture;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent<TransportService> {
    private final AtomicBoolean started = new AtomicBoolean(false);
    protected final Transport transport;
    protected final ThreadPool threadPool;
    volatile ImmutableMap<String, TransportRequestHandler> serverHandlers = ImmutableMap.of();
    final Object serverHandlersMutex = new Object();
    final ConcurrentMapLong<RequestHolder> clientHandlers = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    final AtomicLong requestIds = new AtomicLong();
    final CopyOnWriteArrayList<TransportConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    private final Adapter adapter;
    public static final String SETTING_TRACE_LOG_INCLUDE = "transport.tracer.include";
    public static final String SETTING_TRACE_LOG_EXCLUDE = "transport.tracer.exclude";
    private final ESLogger tracerLog;
    volatile String[] tracerLogInclude;
    volatile String[] tracelLogExclude;
    private final ApplySettings settingsListener = new ApplySettings();

    public TransportService(Transport transport, ThreadPool threadPool) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, transport, threadPool);
    }

    @Inject
    public TransportService(Settings settings, Transport transport, ThreadPool threadPool) {
        super(settings);
        this.transport = transport;
        this.threadPool = threadPool;
        this.tracerLogInclude = settings.getAsArray(SETTING_TRACE_LOG_INCLUDE, Strings.EMPTY_ARRAY, true);
        this.tracelLogExclude = settings.getAsArray(SETTING_TRACE_LOG_EXCLUDE, new String[]{"internal:discovery/zen/fd*"}, true);
        this.tracerLog = Loggers.getLogger(this.logger, ".tracer");
        this.adapter = this.createAdapter();
    }

    protected Adapter createAdapter() {
        return new Adapter();
    }

    @Inject(optional=true)
    public void setDynamicSettings(NodeSettingsService nodeSettingsService, @ClusterDynamicSettings DynamicSettings dynamicSettings) {
        dynamicSettings.addDynamicSettings(SETTING_TRACE_LOG_INCLUDE, "transport.tracer.include.*");
        dynamicSettings.addDynamicSettings(SETTING_TRACE_LOG_EXCLUDE, "transport.tracer.exclude.*");
        nodeSettingsService.addListener(this.settingsListener);
    }

    public void applySettings(Settings settings) {
        this.settingsListener.onRefreshSettings(settings);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.adapter.rxMetric.clear();
        this.adapter.txMetric.clear();
        this.transport.transportServiceAdapter(this.adapter);
        this.transport.start();
        if (this.transport.boundAddress() != null && this.logger.isInfoEnabled()) {
            this.logger.info("{}", this.transport.boundAddress());
        }
        boolean setStarted = this.started.compareAndSet(false, true);
        assert (setStarted) : "service was already started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws ElasticsearchException {
        boolean setStopped = this.started.compareAndSet(true, false);
        assert (setStopped) : "service has already been stopped";
        try {
            this.transport.stop();
        }
        catch (Throwable throwable) {
            for (Map.Entry entry : this.clientHandlers.entrySet()) {
                RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
                if (holderToNotify == null) continue;
                this.threadPool.generic().execute(new Runnable(holderToNotify){
                    final /* synthetic */ RequestHolder val$holderToNotify;
                    {
                        this.val$holderToNotify = requestHolder;
                    }

                    @Override
                    public void run() {
                        this.val$holderToNotify.handler().handleException(new TransportException("transport stopped, action: " + this.val$holderToNotify.action()));
                    }
                });
            }
            throw throwable;
        }
        for (Map.Entry entry : this.clientHandlers.entrySet()) {
            RequestHolder holderToNotify = (RequestHolder)this.clientHandlers.remove(entry.getKey());
            if (holderToNotify == null) continue;
            this.threadPool.generic().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.transport.close();
    }

    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return this.transport.addressSupported(address);
    }

    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new TransportInfo(boundTransportAddress, this.transport.profileBoundAddresses());
    }

    public TransportStats stats() {
        return new TransportStats(this.transport.serverOpen(), this.adapter.rxMetric.count(), this.adapter.rxMetric.sum(), this.adapter.txMetric.count(), this.adapter.txMetric.sum());
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.transport.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        this.transport.connectToNode(node);
    }

    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.transport.connectToNodeLight(node);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        this.transport.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        this.sendRequest(node, action, request, options, futureHandler);
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        this.sendRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        block6: {
            if (node == null) {
                throw new ElasticsearchIllegalStateException("can't send request to a null node");
            }
            long requestId = this.newRequestId();
            TimeoutHandler timeoutHandler = null;
            try {
                this.clientHandlers.put(requestId, new RequestHolder<T>(handler, node, action, timeoutHandler));
                if (!this.started.get()) {
                    throw new TransportException("TransportService is closed stopped can't send request");
                }
                if (options.timeout() != null) {
                    timeoutHandler = new TimeoutHandler(requestId);
                    timeoutHandler.future = this.threadPool.schedule(options.timeout(), "generic", timeoutHandler);
                }
                this.transport.sendRequest(node, requestId, action, request, options);
            }
            catch (Throwable e) {
                final RequestHolder holderToNotify = this.clientHandlers.remove(requestId);
                if (timeoutHandler != null) {
                    FutureUtils.cancel(timeoutHandler.future);
                }
                if (holderToNotify == null) break block6;
                final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
                this.threadPool.executor("generic").execute(new Runnable(){

                    @Override
                    public void run() {
                        holderToNotify.handler().handleException(sendRequestException);
                    }
                });
            }
        }
    }

    private boolean shouldTraceAction(String action) {
        if (this.tracerLogInclude.length > 0 && !Regex.simpleMatch(this.tracerLogInclude, action)) {
            return false;
        }
        if (this.tracelLogExclude.length > 0) {
            return !Regex.simpleMatch(this.tracelLogExclude, action);
        }
        return true;
    }

    private long newRequestId() {
        return this.requestIds.getAndIncrement();
    }

    public TransportAddress[] addressesFromString(String address) throws Exception {
        return this.transport.addressesFromString(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(String action, TransportRequestHandler handler) {
        Object object = this.serverHandlersMutex;
        synchronized (object) {
            TransportRequestHandler handlerReplaced = this.serverHandlers.get(action);
            this.serverHandlers = MapBuilder.newMapBuilder(this.serverHandlers).put(action, handler).immutableMap();
            if (handlerReplaced != null) {
                this.logger.warn("Registered two transport handlers for action {}, handlers: {}, {}", action, handler, handlerReplaced);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(String action) {
        Object object = this.serverHandlersMutex;
        synchronized (object) {
            this.serverHandlers = MapBuilder.newMapBuilder(this.serverHandlers).remove(action).immutableMap();
        }
    }

    protected TransportRequestHandler getHandler(String action) {
        return this.serverHandlers.get(action);
    }

    static class RequestHolder<T extends TransportResponse> {
        private final TransportResponseHandler<T> handler;
        private final DiscoveryNode node;
        private final String action;
        private final TimeoutHandler timeout;

        RequestHolder(TransportResponseHandler<T> handler, DiscoveryNode node, String action, TimeoutHandler timeout) {
            this.handler = handler;
            this.node = node;
            this.action = action;
            this.timeout = timeout;
        }

        public TransportResponseHandler<T> handler() {
            return this.handler;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public void cancel() {
            if (this.timeout != null) {
                FutureUtils.cancel(this.timeout.future);
            }
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        ScheduledFuture future;

        TimeoutHandler(long requestId) {
            this.requestId = requestId;
        }

        public long sentTime() {
            return this.sentTime;
        }

        @Override
        public void run() {
            if (this.future.isCancelled()) {
                return;
            }
            RequestHolder holder = TransportService.this.clientHandlers.remove(this.requestId);
            if (holder != null) {
                long timeoutTime = System.currentTimeMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(holder.node(), holder.action(), this.sentTime, timeoutTime));
                holder.handler().handleException(new ReceiveTimeoutTransportException(holder.node(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
            }
        }
    }

    protected class Adapter
    implements TransportServiceAdapter {
        final MeanMetric rxMetric = new MeanMetric();
        final MeanMetric txMetric = new MeanMetric();

        protected Adapter() {
        }

        @Override
        public void received(long size) {
            this.rxMetric.inc(size);
        }

        @Override
        public void sent(long size) {
            this.txMetric.inc(size);
        }

        @Override
        public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceRequestSent(node, requestId, action, options);
            }
        }

        protected boolean traceEnabled() {
            return TransportService.this.tracerLog.isTraceEnabled();
        }

        @Override
        public void onResponseSent(long requestId, String action, TransportResponse response, TransportResponseOptions options) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action);
            }
        }

        @Override
        public void onResponseSent(long requestId, String action, Throwable t) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceResponseSent(requestId, action, t);
            }
        }

        protected void traceResponseSent(long requestId, String action, Throwable t) {
            TransportService.this.tracerLog.trace("[{}][{}] sent error response (error: [{}])", requestId, action, t.getMessage());
        }

        @Override
        public void onResponseReceived(long requestId) {
            if (this.traceEnabled()) {
                DiscoveryNode sourceNode = null;
                String action = null;
                RequestHolder holder = TransportService.this.clientHandlers.get(requestId);
                if (holder != null) {
                    action = holder.action();
                    sourceNode = holder.node();
                } else {
                    TimeoutInfoHolder timeoutInfoHolder = TransportService.this.timeoutInfoHandlers.get(requestId);
                    if (timeoutInfoHolder != null) {
                        action = timeoutInfoHolder.action();
                        sourceNode = timeoutInfoHolder.node();
                    }
                }
                if (action == null) {
                    this.traceUnresolvedResponse(requestId);
                } else if (TransportService.this.shouldTraceAction(action)) {
                    this.traceReceivedResponse(requestId, sourceNode, action);
                }
            }
        }

        @Override
        public void onRequestReceived(long requestId, String action) {
            if (this.traceEnabled() && TransportService.this.shouldTraceAction(action)) {
                this.traceReceivedRequest(requestId, action);
            }
        }

        @Override
        public TransportRequestHandler handler(String action, Version version) {
            return TransportService.this.serverHandlers.get(ActionNames.incomingAction(action, version));
        }

        @Override
        public TransportResponseHandler remove(long requestId) {
            RequestHolder holder = TransportService.this.clientHandlers.remove(requestId);
            if (holder == null) {
                TimeoutInfoHolder timeoutInfoHolder = TransportService.this.timeoutInfoHandlers.remove(requestId);
                if (timeoutInfoHolder != null) {
                    long time = System.currentTimeMillis();
                    TransportService.this.logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", time - timeoutInfoHolder.sentTime(), time - timeoutInfoHolder.timeoutTime(), timeoutInfoHolder.action(), timeoutInfoHolder.node(), requestId);
                } else {
                    TransportService.this.logger.warn("Transport response handler not found of id [{}]", requestId);
                }
                return null;
            }
            holder.cancel();
            return holder.handler();
        }

        @Override
        public void raiseNodeConnected(final DiscoveryNode node) {
            TransportService.this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    for (TransportConnectionListener connectionListener : TransportService.this.connectionListeners) {
                        connectionListener.onNodeConnected(node);
                    }
                }
            });
        }

        @Override
        public void raiseNodeDisconnected(final DiscoveryNode node) {
            try {
                for (final TransportConnectionListener transportConnectionListener : TransportService.this.connectionListeners) {
                    TransportService.this.threadPool.generic().execute(new Runnable(){

                        @Override
                        public void run() {
                            transportConnectionListener.onNodeDisconnected(node);
                        }
                    });
                }
                for (Map.Entry entry : TransportService.this.clientHandlers.entrySet()) {
                    RequestHolder holderToNotify;
                    RequestHolder holder = (RequestHolder)entry.getValue();
                    if (!holder.node().equals(node) || (holderToNotify = (RequestHolder)TransportService.this.clientHandlers.remove(entry.getKey())) == null) continue;
                    TransportService.this.threadPool.generic().execute(new Runnable(){

                        @Override
                        public void run() {
                            holderToNotify.handler().handleException(new NodeDisconnectedException(node, holderToNotify.action()));
                        }
                    });
                }
            }
            catch (EsRejectedExecutionException ex) {
                TransportService.this.logger.debug("Rejected execution on NodeDisconnected", ex, new Object[0]);
            }
        }

        @Override
        public String action(String action, Version version) {
            return ActionNames.outgoingAction(action, version);
        }

        protected void traceReceivedRequest(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received request", requestId, action);
        }

        protected void traceResponseSent(long requestId, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] sent response", requestId, action);
        }

        protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            TransportService.this.tracerLog.trace("[{}][{}] received response from [{}]", requestId, action, sourceNode);
        }

        protected void traceUnresolvedResponse(long requestId) {
            TransportService.this.tracerLog.trace("[{}] received response but can't resolve it to a request", requestId);
        }

        protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            TransportService.this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", requestId, action, node, options.timeout());
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            Object[] newTracerLogInclude = settings.getAsArray(TransportService.SETTING_TRACE_LOG_INCLUDE, TransportService.this.tracerLogInclude, true);
            Object[] newTracerLogExclude = settings.getAsArray(TransportService.SETTING_TRACE_LOG_EXCLUDE, TransportService.this.tracelLogExclude, true);
            if (newTracerLogInclude == TransportService.this.tracerLogInclude && newTracerLogExclude == TransportService.this.tracelLogExclude) {
                return;
            }
            if (Arrays.equals(newTracerLogInclude, TransportService.this.tracerLogInclude) && Arrays.equals(newTracerLogExclude, TransportService.this.tracelLogExclude)) {
                return;
            }
            TransportService.this.tracerLogInclude = newTracerLogInclude;
            TransportService.this.tracelLogExclude = newTracerLogExclude;
            TransportService.this.logger.info("tracer log updated to use include: {}, exclude: {}", newTracerLogInclude, newTracerLogExclude);
        }
    }
}

