/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.innerhits;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.FilteredSearchContext;
import org.elasticsearch.search.internal.SearchContext;

public final class InnerHitsContext {
    private final Map<String, BaseInnerHits> innerHits;

    public InnerHitsContext(Map<String, BaseInnerHits> innerHits) {
        this.innerHits = innerHits;
    }

    public Map<String, BaseInnerHits> getInnerHits() {
        return this.innerHits;
    }

    public void addInnerHitDefinition(String name, BaseInnerHits innerHit) {
        this.innerHits.put(name, innerHit);
    }

    public static final class ParentChildInnerHits
    extends BaseInnerHits {
        private final DocumentMapper documentMapper;

        public ParentChildInnerHits(SearchContext context, Query query, Map<String, BaseInnerHits> childInnerHits, DocumentMapper documentMapper) {
            super(context, query, childInnerHits);
            this.documentMapper = documentMapper;
        }

        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            String term;
            String field;
            int topN = this.from() + this.size();
            Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort(), (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores(), (boolean)false) : TopScoreDocCollector.create((int)topN, (boolean)false);
            if (this.documentMapper.parentFieldMapper().active()) {
                field = "_parent";
                term = Uid.createUid(hitContext.hit().type(), hitContext.hit().id());
            } else {
                field = "_uid";
                SearchHitField parentField = hitContext.hit().field("_parent");
                if (parentField != null) {
                    term = (String)parentField.getValue();
                } else {
                    SingleFieldsVisitor fieldsVisitor = new SingleFieldsVisitor("_parent");
                    hitContext.reader().document(hitContext.docId(), (StoredFieldVisitor)fieldsVisitor);
                    if (fieldsVisitor.fields().isEmpty()) {
                        return Lucene.EMPTY_TOP_DOCS;
                    }
                    term = (String)fieldsVisitor.fields().get("_parent").get(0);
                }
            }
            TermFilter filter = new TermFilter(new Term(field, term));
            Filter typeFilter = this.documentMapper.typeFilter();
            context.searcher().search(new XFilteredQuery(this.query, new AndFilter(Arrays.asList(filter, typeFilter))), (Collector)topDocsCollector);
            return topDocsCollector.topDocs(this.from(), this.size());
        }
    }

    public static final class NestedInnerHits
    extends BaseInnerHits {
        private final ObjectMapper parentObjectMapper;
        private final ObjectMapper childObjectMapper;

        public NestedInnerHits(SearchContext context, Query query, Map<String, BaseInnerHits> childInnerHits, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper) {
            super(context, query, childInnerHits);
            this.parentObjectMapper = parentObjectMapper;
            this.childObjectMapper = childObjectMapper;
        }

        @Override
        public TopDocs topDocs(SearchContext context, FetchSubPhase.HitContext hitContext) throws IOException {
            TopScoreDocCollector topDocsCollector;
            int topN = this.from() + this.size();
            if (this.sort() != null) {
                try {
                    topDocsCollector = TopFieldCollector.create((Sort)this.sort(), (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores(), (boolean)true);
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToElastic(e);
                }
            } else {
                topDocsCollector = TopScoreDocCollector.create((int)topN, (boolean)true);
            }
            NonNestedDocsFilter rawParentFilter = this.parentObjectMapper == null ? NonNestedDocsFilter.INSTANCE : this.parentObjectMapper.nestedTypeFilter();
            FixedBitSetFilter parentFilter = context.fixedBitSetFilterCache().getFixedBitSetFilter(rawParentFilter);
            Filter childFilter = context.filterCache().cache(this.childObjectMapper.nestedTypeFilter());
            XFilteredQuery q = new XFilteredQuery(this.query, new NestedChildrenFilter(parentFilter, childFilter, hitContext));
            context.searcher().search(q, (Collector)topDocsCollector);
            return topDocsCollector.topDocs(this.from(), this.size());
        }

        static class NestedChildrenFilter
        extends Filter {
            private final FixedBitSetFilter parentFilter;
            private final Filter childFilter;
            private final int docId;
            private final AtomicReader atomicReader;

            NestedChildrenFilter(FixedBitSetFilter parentFilter, Filter childFilter, FetchSubPhase.HitContext hitContext) {
                this.parentFilter = parentFilter;
                this.childFilter = childFilter;
                this.docId = hitContext.docId();
                this.atomicReader = hitContext.readerContext().reader();
            }

            public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
                if (!context.reader().getCoreCacheKey().equals(this.atomicReader.getCoreCacheKey())) {
                    return null;
                }
                if (this.docId == 0) {
                    return null;
                }
                final FixedBitSet parents = this.parentFilter.getDocIdSet(context, null);
                final int firstChildDocId = parents.prevSetBit(this.docId - 1) + 1;
                if (firstChildDocId == this.docId) {
                    return null;
                }
                final DocIdSet children = this.childFilter.getDocIdSet(context, acceptDocs);
                if (children == null) {
                    return null;
                }
                final DocIdSetIterator childrenIterator = children.iterator();
                if (childrenIterator == null) {
                    return null;
                }
                return new DocIdSet(){

                    public long ramBytesUsed() {
                        return parents.ramBytesUsed() + children.ramBytesUsed();
                    }

                    public DocIdSetIterator iterator() throws IOException {
                        return new DocIdSetIterator(){
                            int currentDocId = -1;

                            public int docID() {
                                return this.currentDocId;
                            }

                            public int nextDoc() throws IOException {
                                return this.advance(this.currentDocId + 1);
                            }

                            public int advance(int target) throws IOException {
                                if ((target = Math.max(firstChildDocId, target)) >= NestedChildrenFilter.this.docId) {
                                    this.currentDocId = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                int advanced = childrenIterator.advance(target);
                                if (advanced >= NestedChildrenFilter.this.docId) {
                                    this.currentDocId = Integer.MAX_VALUE;
                                    return Integer.MAX_VALUE;
                                }
                                this.currentDocId = advanced;
                                return this.currentDocId;
                            }

                            public long cost() {
                                return childrenIterator.cost();
                            }
                        };
                    }
                };
            }
        }
    }

    public static abstract class BaseInnerHits
    extends FilteredSearchContext {
        protected final Query query;
        private final InnerHitsContext childInnerHits;

        protected BaseInnerHits(SearchContext context, Query query, Map<String, BaseInnerHits> childInnerHits) {
            super(context);
            this.query = query;
            this.childInnerHits = childInnerHits != null && !childInnerHits.isEmpty() ? new InnerHitsContext(childInnerHits) : null;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public ParsedQuery parsedQuery() {
            return new ParsedQuery(this.query, ImmutableMap.of());
        }

        public abstract TopDocs topDocs(SearchContext var1, FetchSubPhase.HitContext var2) throws IOException;

        @Override
        public InnerHitsContext innerHits() {
            return this.childInnerHits;
        }
    }
}

