/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class PercentageScore
extends SignificanceHeuristic {
    public static final PercentageScore INSTANCE = new PercentageScore();
    protected static final String[] NAMES = new String[]{"percentage"};
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return PercentageScore.readFrom(in);
        }

        @Override
        public String getName() {
            return NAMES[0];
        }
    };

    private PercentageScore() {
    }

    public static SignificanceHeuristic readFrom(StreamInput in) throws IOException {
        return INSTANCE;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "PercentageScore");
        if (supersetFreq == 0L) {
            return 0.0;
        }
        return (double)subsetFreq / (double)supersetFreq;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
    }

    public static class PercentageScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public void toXContent(XContentBuilder builder) throws IOException {
            builder.startObject(STREAM.getName()).endObject();
        }
    }

    public static class PercentageScoreParser
    implements SignificanceHeuristicParser {
        @Override
        public SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryParsingException {
            if (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
                throw new ElasticsearchParseException("expected }, got " + parser.currentName() + " instead in percentage score");
            }
            return new PercentageScore();
        }

        @Override
        public String[] getNames() {
            return NAMES;
        }
    }
}

