/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.groovy.GroovySandboxExpressionChecker;
import org.elasticsearch.script.groovy.GroovyScriptCompilationException;
import org.elasticsearch.script.groovy.GroovyScriptExecutionException;
import org.elasticsearch.search.lookup.SearchLookup;

public class GroovyScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "groovy";
    public static String GROOVY_SCRIPT_SANDBOX_ENABLED = "script.groovy.sandbox.enabled";
    public static String GROOVY_SCRIPT_BLACKLIST_PATCH = "script.groovy.sandbox.method_blacklist_patch";
    private final AtomicLong counter = new AtomicLong();
    private final boolean sandboxed;
    private volatile GroovyClassLoader loader;
    private volatile Set<String> blacklistAdditions;

    @Inject
    public GroovyScriptEngineService(Settings settings) {
        super(settings);
        this.sandboxed = settings.getAsBoolean(GROOVY_SCRIPT_SANDBOX_ENABLED, (Boolean)false);
        this.blacklistAdditions = ImmutableSet.copyOf(settings.getAsArray(GROOVY_SCRIPT_BLACKLIST_PATCH, Strings.EMPTY_ARRAY));
        this.reloadConfig();
    }

    public Set<String> blacklistAdditions() {
        return this.blacklistAdditions;
    }

    public boolean addToBlacklist(String ... additions) {
        HashSet<String> newBlackList = new HashSet<String>(this.blacklistAdditions);
        Collections.addAll(newBlackList, additions);
        boolean changed = !this.blacklistAdditions.equals(newBlackList);
        this.blacklistAdditions = ImmutableSet.copyOf(newBlackList);
        return changed;
    }

    public void reloadConfig() {
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"org.elasticsearch.common.joda.time"});
        imports.addStaticStars(new String[]{"java.lang.Math"});
        CompilerConfiguration config = new CompilerConfiguration();
        config.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        if (this.sandboxed) {
            config.addCompilationCustomizers(new CompilationCustomizer[]{GroovySandboxExpressionChecker.getSecureASTCustomizer(this.settings, this.blacklistAdditions)});
        }
        config.addCompilationCustomizers(new CompilationCustomizer[]{new GroovyBigDecimalTransformer(CompilePhase.CONVERSION)});
        this.loader = new GroovyClassLoader(this.settings.getClassLoader(), config);
    }

    @Override
    public void close() {
        this.loader.clearCache();
        try {
            this.loader.close();
        }
        catch (IOException e) {
            this.logger.warn("Unable to close Groovy loader", e, new Object[0]);
        }
    }

    @Override
    public void scriptRemoved(@Nullable CompiledScript script) {
        if (script == null || NAME.equals(script.lang())) {
            this.loader.clearCache();
        }
    }

    @Override
    public String[] types() {
        return new String[]{NAME};
    }

    @Override
    public String[] extensions() {
        return new String[]{NAME};
    }

    @Override
    public boolean sandboxed() {
        return this.sandboxed;
    }

    @Override
    public Object compile(String script) {
        try {
            return this.loader.parseClass(script, this.generateScriptName());
        }
        catch (Throwable e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("exception compiling Groovy script:", e, new Object[0]);
            }
            throw new GroovyScriptCompilationException(ExceptionsHelper.detailedMessage(e));
        }
    }

    private Script createScript(Object compiledScript, Map<String, Object> vars) throws InstantiationException, IllegalAccessException {
        Class scriptClass = (Class)compiledScript;
        Script scriptObject = (Script)scriptClass.newInstance();
        Binding binding = new Binding();
        binding.getVariables().putAll(vars);
        scriptObject.setBinding(binding);
        return scriptObject;
    }

    @Override
    public ExecutableScript executable(Object compiledScript, Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            return new GroovyScript(this.createScript(compiledScript, allVars), this.logger);
        }
        catch (Exception e) {
            throw new ScriptException("failed to build executable script", e);
        }
    }

    @Override
    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            allVars.putAll(lookup.asMap());
            if (vars != null) {
                allVars.putAll(vars);
            }
            Script scriptObject = this.createScript(compiledScript, allVars);
            return new GroovyScript(scriptObject, lookup, this.logger);
        }
        catch (Exception e) {
            throw new ScriptException("failed to build search script", e);
        }
    }

    @Override
    public Object execute(Object compiledScript, Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            Script scriptObject = this.createScript(compiledScript, allVars);
            return scriptObject.run();
        }
        catch (Exception e) {
            throw new ScriptException("failed to execute script", e);
        }
    }

    @Override
    public Object unwrap(Object value) {
        return value;
    }

    private String generateScriptName() {
        return "Script" + this.counter.incrementAndGet() + ".groovy";
    }

    private class BigDecimalExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit source;

        private BigDecimalExpressionTransformer(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public Expression transform(Expression expr) {
            ConstantExpression constExpr;
            Object val;
            Expression newExpr = expr;
            if (expr instanceof ConstantExpression && (val = (constExpr = (ConstantExpression)expr).getValue()) != null && val instanceof BigDecimal) {
                newExpr = new ConstantExpression((Object)((BigDecimal)val).doubleValue());
            }
            return super.transform(newExpr);
        }
    }

    private class GroovyBigDecimalTransformer
    extends CompilationCustomizer {
        private GroovyBigDecimalTransformer(CompilePhase phase) {
            super(phase);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            new BigDecimalExpressionTransformer(source).visitClass(classNode);
        }
    }

    public static final class GroovyScript
    implements ExecutableScript,
    SearchScript {
        private final Script script;
        private final SearchLookup lookup;
        private final Map<String, Object> variables;
        private final ESLogger logger;

        public GroovyScript(Script script, ESLogger logger) {
            this(script, null, logger);
        }

        public GroovyScript(Script script, @Nullable SearchLookup lookup, ESLogger logger) {
            this.script = script;
            this.lookup = lookup;
            this.logger = logger;
            this.variables = script.getBinding().getVariables();
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.variables.put("_score", new ScoreAccessor(scorer));
        }

        @Override
        public void setNextReader(AtomicReaderContext context) {
            if (this.lookup != null) {
                this.lookup.setNextReader(context);
            }
        }

        @Override
        public void setNextDocId(int doc) {
            if (this.lookup != null) {
                this.lookup.setNextDocId(doc);
            }
        }

        @Override
        public void setNextVar(String name, Object value) {
            this.variables.put(name, value);
        }

        @Override
        public void setNextSource(Map<String, Object> source) {
            if (this.lookup != null) {
                this.lookup.source().setNextSource(source);
            }
        }

        @Override
        public Object run() {
            try {
                return this.script.run();
            }
            catch (Throwable e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("exception running Groovy script", e, new Object[0]);
                }
                throw new GroovyScriptExecutionException(ExceptionsHelper.detailedMessage(e));
            }
        }

        @Override
        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        @Override
        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        @Override
        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        @Override
        public Object unwrap(Object value) {
            return value;
        }
    }
}

