/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.text.ParseException;
import java.util.Map;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.expressions.js.VariableContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.ExpressionScript;
import org.elasticsearch.script.expression.ExpressionScriptCompilationException;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.script.expression.ReplaceableConstValueSource;
import org.elasticsearch.search.lookup.SearchLookup;

public class ExpressionScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "expression";

    @Inject
    public ExpressionScriptEngineService(Settings settings) {
        super(settings);
    }

    @Override
    public String[] types() {
        return new String[]{NAME};
    }

    @Override
    public String[] extensions() {
        return new String[]{NAME};
    }

    @Override
    public boolean sandboxed() {
        return true;
    }

    @Override
    public Object compile(String script) {
        try {
            return JavascriptCompiler.compile((String)script);
        }
        catch (ParseException e) {
            throw new ExpressionScriptCompilationException("Failed to parse expression: " + script, e);
        }
    }

    @Override
    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        Expression expr = (Expression)compiledScript;
        MapperService mapper = lookup.doc().mapperService();
        SimpleBindings bindings = new SimpleBindings();
        ReplaceableConstValueSource specialValue = null;
        for (String variable : expr.variables) {
            if (variable.equals("_score")) {
                bindings.add(new SortField("_score", SortField.Type.SCORE));
                continue;
            }
            if (variable.equals("_value")) {
                specialValue = new ReplaceableConstValueSource();
                bindings.add("_value", (ValueSource)specialValue);
                continue;
            }
            if (vars != null && vars.containsKey(variable)) {
                Object value = vars.get(variable);
                if (value instanceof Number) {
                    bindings.add(variable, (ValueSource)new DoubleConstValueSource(((Number)value).doubleValue()));
                    continue;
                }
                throw new ExpressionScriptCompilationException("Parameter [" + variable + "] must be a numeric type");
            }
            VariableContext[] parts = VariableContext.parse((String)variable);
            if (!parts[0].text.equals("doc")) {
                throw new ExpressionScriptCompilationException("Unknown variable [" + parts[0].text + "] in expression");
            }
            if (parts.length < 2 || parts[1].type != VariableContext.Type.STR_INDEX) {
                throw new ExpressionScriptCompilationException("Variable 'doc' in expression must be used with a specific field like: doc['myfield'].value");
            }
            if (parts.length < 3 || parts[2].type != VariableContext.Type.MEMBER || !parts[2].text.equals("value")) {
                throw new ExpressionScriptCompilationException("Invalid member for field data in expression.  Only '.value' is currently supported.");
            }
            String fieldname = parts[1].text;
            FieldMapper field = mapper.smartNameFieldMapper(fieldname);
            if (field == null) {
                throw new ExpressionScriptCompilationException("Field [" + fieldname + "] used in expression does not exist in mappings");
            }
            if (!field.isNumeric()) {
                throw new ExpressionScriptCompilationException("Field [" + fieldname + "] used in expression must be numeric");
            }
            Object fieldData = lookup.doc().fieldDataService().getForField((NumberFieldMapper)field);
            bindings.add(variable, (ValueSource)new FieldDataValueSource((IndexFieldData<?>)fieldData));
        }
        return new ExpressionScript((Expression)compiledScript, bindings, specialValue);
    }

    @Override
    public ExecutableScript executable(Object compiledScript, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException("Cannot use expressions for updates");
    }

    @Override
    public Object execute(Object compiledScript, Map<String, Object> vars) {
        throw new UnsupportedOperationException("Cannot use expressions for updates");
    }

    @Override
    public Object unwrap(Object value) {
        return value;
    }

    @Override
    public void close() {
    }

    @Override
    public void scriptRemoved(CompiledScript script) {
    }
}

