/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.explain;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class RestExplainAction
extends BaseRestHandler {
    @Inject
    public RestExplainAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_explain", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_explain", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        String[] sFields;
        final ExplainRequest explainRequest = new ExplainRequest(request.param("index"), request.param("type"), request.param("id"));
        explainRequest.parent(request.param("parent"));
        explainRequest.routing(request.param("routing"));
        explainRequest.preference(request.param("preference"));
        String sourceString = request.param("source");
        String queryString = request.param("q");
        if (request.hasContent()) {
            explainRequest.source(request.content(), request.contentUnsafe());
        } else if (sourceString != null) {
            explainRequest.source(new BytesArray(request.param("source")), false);
        } else if (queryString != null) {
            QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery(queryString);
            queryStringBuilder.defaultField(request.param("df"));
            queryStringBuilder.analyzer(request.param("analyzer"));
            queryStringBuilder.analyzeWildcard(request.paramAsBoolean("analyze_wildcard", false));
            queryStringBuilder.lowercaseExpandedTerms(request.paramAsBoolean("lowercase_expanded_terms", true));
            queryStringBuilder.lenient(request.paramAsBoolean("lenient", null));
            String defaultOperator = request.param("default_operator");
            if (defaultOperator != null) {
                if ("OR".equals(defaultOperator)) {
                    queryStringBuilder.defaultOperator(QueryStringQueryBuilder.Operator.OR);
                } else if ("AND".equals(defaultOperator)) {
                    queryStringBuilder.defaultOperator(QueryStringQueryBuilder.Operator.AND);
                } else {
                    throw new ElasticsearchIllegalArgumentException("Unsupported defaultOperator [" + defaultOperator + "], can either be [OR] or [AND]");
                }
            }
            QuerySourceBuilder querySourceBuilder = new QuerySourceBuilder();
            querySourceBuilder.setQuery(queryStringBuilder);
            explainRequest.source(querySourceBuilder);
        }
        String sField = request.param("fields");
        if (sField != null && (sFields = Strings.splitStringByCommaToArray(sField)) != null) {
            explainRequest.fields(sFields);
        }
        explainRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        client.explain(explainRequest, (ActionListener<ExplainResponse>)new RestBuilderListener<ExplainResponse>(channel){

            @Override
            public RestResponse buildResponse(ExplainResponse response, XContentBuilder builder) throws Exception {
                GetResult getResult;
                builder.startObject();
                builder.field(Fields._INDEX, response.getIndex() != null ? response.getIndex() : explainRequest.index()).field(Fields._TYPE, response.getType() != null ? response.getType() : explainRequest.type()).field(Fields._ID, response.getId() != null ? response.getId() : explainRequest.id()).field(Fields.MATCHED, response.isMatch());
                if (response.hasExplanation()) {
                    builder.startObject(Fields.EXPLANATION);
                    this.buildExplanation(builder, response.getExplanation());
                    builder.endObject();
                }
                if ((getResult = response.getGetResult()) != null) {
                    builder.startObject(Fields.GET);
                    response.getGetResult().toXContentEmbedded(builder, request);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }

            private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
                builder.field(Fields.VALUE, explanation.getValue());
                builder.field(Fields.DESCRIPTION, explanation.getDescription());
                Explanation[] innerExps = explanation.getDetails();
                if (innerExps != null) {
                    builder.startArray(Fields.DETAILS);
                    for (Explanation exp : innerExps) {
                        builder.startObject();
                        this.buildExplanation(builder, exp);
                        builder.endObject();
                    }
                    builder.endArray();
                }
            }
        });
    }

    static class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString MATCHED = new XContentBuilderString("matched");
        static final XContentBuilderString EXPLANATION = new XContentBuilderString("explanation");
        static final XContentBuilderString VALUE = new XContentBuilderString("value");
        static final XContentBuilderString DESCRIPTION = new XContentBuilderString("description");
        static final XContentBuilderString DETAILS = new XContentBuilderString("details");
        static final XContentBuilderString GET = new XContentBuilderString("get");

        Fields() {
        }
    }
}

