/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.process.JmxProcessProbe;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;
import org.elasticsearch.monitor.sigar.SigarService;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarProcessProbe
extends AbstractComponent
implements ProcessProbe {
    private final SigarService sigarService;

    @Inject
    public SigarProcessProbe(Settings settings, SigarService sigarService) {
        super(settings);
        this.sigarService = sigarService;
    }

    @Override
    public synchronized ProcessInfo processInfo() {
        return new ProcessInfo(this.sigarService.sigar().getPid(), JmxProcessProbe.getMaxFileDescriptorCount());
    }

    @Override
    public synchronized ProcessStats processStats() {
        Sigar sigar = this.sigarService.sigar();
        ProcessStats stats = new ProcessStats();
        stats.timestamp = System.currentTimeMillis();
        stats.openFileDescriptors = JmxProcessProbe.getOpenFileDescriptorCount();
        try {
            if (stats.openFileDescriptors == -1L) {
                stats.openFileDescriptors = sigar.getProcFd(sigar.getPid()).getTotal();
            }
            ProcCpu cpu = sigar.getProcCpu(sigar.getPid());
            stats.cpu = new ProcessStats.Cpu();
            stats.cpu.percent = (short)(cpu.getPercent() * 100.0);
            stats.cpu.sys = cpu.getSys();
            stats.cpu.user = cpu.getUser();
            stats.cpu.total = cpu.getTotal();
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            ProcMem mem = sigar.getProcMem(sigar.getPid());
            stats.mem = new ProcessStats.Mem();
            stats.mem.totalVirtual = mem.getSize();
            stats.mem.resident = mem.getResident();
            stats.mem.share = mem.getShare();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return stats;
    }
}

