/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.text.UTF8SortedAsUnicodeComparator;

public class StringAndBytesText
implements Text {
    public static final Text[] EMPTY_ARRAY = new Text[0];
    private BytesReference bytes;
    private String text;
    private int hash;

    public static Text[] convertFromStringArray(String[] strings) {
        if (strings.length == 0) {
            return EMPTY_ARRAY;
        }
        Text[] texts = new Text[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            texts[i] = new StringAndBytesText(strings[i]);
        }
        return texts;
    }

    public StringAndBytesText(BytesReference bytes) {
        this.bytes = bytes;
    }

    public StringAndBytesText(String text) {
        this.text = text;
    }

    @Override
    public boolean hasBytes() {
        return this.bytes != null;
    }

    @Override
    public BytesReference bytes() {
        if (this.bytes == null) {
            this.bytes = new BytesArray(this.text.getBytes(Charsets.UTF_8));
        }
        return this.bytes;
    }

    @Override
    public boolean hasString() {
        return this.text != null;
    }

    @Override
    public String string() {
        if (this.text == null) {
            if (!this.bytes.hasArray()) {
                this.bytes = this.bytes.toBytesArray();
            }
            this.text = new String(this.bytes.array(), this.bytes.arrayOffset(), this.bytes.length(), Charsets.UTF_8);
        }
        return this.text;
    }

    @Override
    public String toString() {
        return this.string();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.bytes().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.bytes().equals(((Text)obj).bytes());
    }

    @Override
    public int compareTo(Text text) {
        return UTF8SortedAsUnicodeComparator.utf8SortedAsUnicodeSortOrder.compare(this.bytes(), text.bytes());
    }
}

