/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;

public class BytesStreamInput
extends StreamInput {
    protected byte[] buf;
    protected int pos;
    protected int end;
    private final boolean unsafe;

    public BytesStreamInput(BytesReference bytes) {
        if (!bytes.hasArray()) {
            bytes = bytes.toBytesArray();
        }
        this.buf = bytes.array();
        this.pos = bytes.arrayOffset();
        this.end = this.pos + bytes.length();
        this.unsafe = false;
    }

    public BytesStreamInput(byte[] buf, boolean unsafe) {
        this(buf, 0, buf.length, unsafe);
    }

    public BytesStreamInput(byte[] buf, int offset, int length, boolean unsafe) {
        this.buf = buf;
        this.pos = offset;
        this.end = offset + length;
        this.unsafe = unsafe;
    }

    @Override
    public BytesReference readBytesReference(int length) throws IOException {
        if (this.unsafe) {
            return super.readBytesReference(length);
        }
        BytesArray bytes = new BytesArray(this.buf, this.pos, length);
        this.pos += length;
        return bytes;
    }

    @Override
    public BytesRef readBytesRef(int length) throws IOException {
        if (this.unsafe) {
            return super.readBytesRef(length);
        }
        BytesRef bytes = new BytesRef(this.buf, this.pos, length);
        this.pos += length;
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((long)this.pos + n > (long)this.end) {
            n = this.end - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int position() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.end ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        if (this.pos + len > this.end) {
            len = this.end - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public byte[] underlyingBuffer() {
        return this.buf;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos >= this.end) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.pos >= this.end) {
            throw new EOFException();
        }
        if (this.pos + len > this.end) {
            len = this.end - this.pos;
        }
        if (len <= 0) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, b, offset, len);
        this.pos += len;
    }

    @Override
    public void reset() throws IOException {
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
    }
}

