/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.recycler;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.AbstractRecyclerC;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.Recyclers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;

public class PageCacheRecycler
extends AbstractComponent {
    public static final String TYPE = "page.type";
    public static final String LIMIT_HEAP = "page.limit.heap";
    public static final String LIMIT_PER_THREAD = "page.limit.per_thread";
    public static final String WEIGHT = "page.weight";
    private final Recycler<byte[]> bytePage;
    private final Recycler<int[]> intPage;
    private final Recycler<long[]> longPage;
    private final Recycler<Object[]> objectPage;

    public void close() {
        this.bytePage.close();
        this.intPage.close();
        this.longPage.close();
        this.objectPage.close();
    }

    private static int maximumSearchThreadPoolSize(ThreadPool threadPool, Settings settings) {
        ThreadPool.Info searchThreadPool = threadPool.info("search");
        assert (searchThreadPool != null);
        int maxSize = searchThreadPool.getMax();
        if (maxSize <= 0) {
            return 3 * EsExecutors.boundedNumberOfProcessors(settings);
        }
        return maxSize;
    }

    @Inject
    public PageCacheRecycler(Settings settings, ThreadPool threadPool) {
        super(settings);
        Type type = Type.parse(this.componentSettings.get(TYPE));
        long limit = this.componentSettings.getAsMemory(LIMIT_HEAP, "10%").bytes();
        int availableProcessors = EsExecutors.boundedNumberOfProcessors(settings);
        int searchThreadPoolSize = PageCacheRecycler.maximumSearchThreadPoolSize(threadPool, settings);
        double bytesWeight = this.componentSettings.getAsDouble("page.weight.bytes", (Double)1.0);
        double intsWeight = this.componentSettings.getAsDouble("page.weight.ints", (Double)1.0);
        double longsWeight = this.componentSettings.getAsDouble("page.weight.longs", (Double)1.0);
        double objectsWeight = this.componentSettings.getAsDouble("page.weight.objects", (Double)0.1);
        double totalWeight = bytesWeight + intsWeight + longsWeight + objectsWeight;
        int maxPageCount = (int)Math.min(Integer.MAX_VALUE, limit / 16384L);
        int maxBytePageCount = (int)(bytesWeight * (double)maxPageCount / totalWeight);
        this.bytePage = PageCacheRecycler.build(type, maxBytePageCount, searchThreadPoolSize, availableProcessors, new AbstractRecyclerC<byte[]>(){

            @Override
            public byte[] newInstance(int sizing) {
                return new byte[16384];
            }

            @Override
            public void recycle(byte[] value) {
            }
        });
        int maxIntPageCount = (int)(intsWeight * (double)maxPageCount / totalWeight);
        this.intPage = PageCacheRecycler.build(type, maxIntPageCount, searchThreadPoolSize, availableProcessors, new AbstractRecyclerC<int[]>(){

            @Override
            public int[] newInstance(int sizing) {
                return new int[4096];
            }

            @Override
            public void recycle(int[] value) {
            }
        });
        int maxLongPageCount = (int)(longsWeight * (double)maxPageCount / totalWeight);
        this.longPage = PageCacheRecycler.build(type, maxLongPageCount, searchThreadPoolSize, availableProcessors, new AbstractRecyclerC<long[]>(){

            @Override
            public long[] newInstance(int sizing) {
                return new long[2048];
            }

            @Override
            public void recycle(long[] value) {
            }
        });
        int maxObjectPageCount = (int)(objectsWeight * (double)maxPageCount / totalWeight);
        this.objectPage = PageCacheRecycler.build(type, maxObjectPageCount, searchThreadPoolSize, availableProcessors, new AbstractRecyclerC<Object[]>(){

            @Override
            public Object[] newInstance(int sizing) {
                return new Object[BigArrays.OBJECT_PAGE_SIZE];
            }

            @Override
            public void recycle(Object[] value) {
                Arrays.fill(value, null);
            }
        });
        assert ((long)(16384 * (maxBytePageCount + maxIntPageCount + maxLongPageCount + maxObjectPageCount)) <= limit);
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        Recycler.V<byte[]> v = this.bytePage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), (byte)0);
        }
        return v;
    }

    public Recycler.V<int[]> intPage(boolean clear) {
        Recycler.V<int[]> v = this.intPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0);
        }
        return v;
    }

    public Recycler.V<long[]> longPage(boolean clear) {
        Recycler.V<long[]> v = this.longPage.obtain();
        if (v.isRecycled() && clear) {
            Arrays.fill(v.v(), 0L);
        }
        return v;
    }

    public Recycler.V<Object[]> objectPage() {
        return this.objectPage.obtain();
    }

    private static <T> Recycler<T> build(Type type, int limit, int estimatedThreadPoolSize, int availableProcessors, Recycler.C<T> c) {
        Recycler<T> recycler = limit == 0 ? Recyclers.none(c) : type.build(c, limit, estimatedThreadPoolSize, availableProcessors);
        return recycler;
    }

    public static enum Type {
        QUEUE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.concurrentDeque(c, limit);
            }
        }
        ,
        CONCURRENT{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.concurrent(Recyclers.dequeFactory(c, limit / availableProcessors), availableProcessors);
            }
        }
        ,
        NONE{

            @Override
            <T> Recycler<T> build(Recycler.C<T> c, int limit, int estimatedThreadPoolSize, int availableProcessors) {
                return Recyclers.none(c);
            }
        };


        public static Type parse(String type) {
            if (Strings.isNullOrEmpty(type)) {
                return CONCURRENT;
            }
            try {
                return Type.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new ElasticsearchIllegalArgumentException("no type support [" + type + "]");
            }
        }

        abstract <T> Recycler<T> build(Recycler.C<T> var1, int var2, int var3, int var4);
    }
}

