/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;

public class DeleteByQueryRequest
extends IndicesReplicationOperationRequest<DeleteByQueryRequest> {
    private BytesReference source;
    private boolean sourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;

    public DeleteByQueryRequest(String ... indices) {
        this.indices = indices;
    }

    public DeleteByQueryRequest() {
    }

    public DeleteByQueryRequest(ActionRequest originalRequest) {
        super(originalRequest);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    public BytesReference source() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
        }
        return this.source;
    }

    public DeleteByQueryRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        this.sourceUnsafe = false;
        return this;
    }

    public DeleteByQueryRequest source(String query) {
        this.source = new BytesArray(query.getBytes(Charsets.UTF_8));
        this.sourceUnsafe = false;
        return this;
    }

    public DeleteByQueryRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public DeleteByQueryRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public DeleteByQueryRequest source(byte[] source) {
        return this.source(source, 0, source.length, false);
    }

    public DeleteByQueryRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = new BytesArray(source, offset, length);
        this.sourceUnsafe = unsafe;
        return this;
    }

    public DeleteByQueryRequest source(BytesReference source, boolean unsafe) {
        this.source = source;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public String routing() {
        return this.routing;
    }

    public DeleteByQueryRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public DeleteByQueryRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public DeleteByQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.sourceUnsafe = false;
        this.source = in.readBytesReference();
        this.routing = in.readOptionalString();
        this.types = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeOptionalString(this.routing);
        out.writeStringArray(this.types);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "][" + Arrays.toString(this.types) + "], source[" + sSource + "]";
    }
}

