/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocumentRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final boolean allowIdGeneration;
    private final ClusterService clusterService;
    private final TransportShardBulkAction shardBulkAction;
    private final TransportCreateIndexAction createIndexAction;

    @Inject
    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters) {
        super(settings, "indices:data/write/bulk", threadPool, transportService, actionFilters);
        this.clusterService = clusterService;
        this.shardBulkAction = shardBulkAction;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = new AutoCreateIndex(settings);
        this.allowIdGeneration = this.componentSettings.getAsBoolean("action.allow_id_generation", (Boolean)true);
    }

    @Override
    public BulkRequest newRequestInstance() {
        return new BulkRequest();
    }

    @Override
    protected void doExecute(final BulkRequest bulkRequest, final ActionListener<BulkResponse> listener) {
        final long startTime = System.currentTimeMillis();
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (this.autoCreateIndex.needToCheck()) {
            HashSet<String> indices = Sets.newHashSet();
            for (ActionRequest request : bulkRequest.requests) {
                if (request instanceof DocumentRequest) {
                    DocumentRequest req = (DocumentRequest)((Object)request);
                    if (indices.contains(req.index())) continue;
                    indices.add(req.index());
                    continue;
                }
                throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName());
            }
            final AtomicInteger counter = new AtomicInteger(indices.size());
            ClusterState state = this.clusterService.state();
            for (final String index : indices) {
                if (this.autoCreateIndex.shouldAutoCreate(index, state)) {
                    this.createIndexAction.execute(new CreateIndexRequest(bulkRequest).index(index).cause("auto(bulk api)").masterNodeTimeout(bulkRequest.timeout()), new ActionListener<CreateIndexResponse>(){

                        @Override
                        public void onResponse(CreateIndexResponse result) {
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener, responses);
                                }
                                catch (Throwable t) {
                                    listener.onFailure(t);
                                }
                            }
                        }

                        @Override
                        public void onFailure(Throwable e) {
                            if (!(ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException)) {
                                for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                    ActionRequest request = bulkRequest.requests.get(i);
                                    if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                    bulkRequest.requests.set(i, null);
                                }
                            }
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(bulkRequest, startTime, listener, responses);
                                }
                                catch (Throwable t) {
                                    listener.onFailure(t);
                                }
                            }
                        }
                    });
                    continue;
                }
                if (counter.decrementAndGet() != 0) continue;
                this.executeBulk(bulkRequest, startTime, listener, responses);
            }
        } else {
            this.executeBulk(bulkRequest, startTime, listener, responses);
        }
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, ActionRequest request, String index, Throwable e) {
        if (request instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)request;
            if (index.equals(indexRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "index", new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e)));
                return true;
            }
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            if (index.equals(deleteRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "index", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), e)));
                return true;
            }
        } else if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            if (index.equals(updateRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "index", new BulkItemResponse.Failure(updateRequest.index(), updateRequest.type(), updateRequest.id(), e)));
                return true;
            }
        } else {
            throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName());
        }
        return false;
    }

    public void executeBulk(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        long startTime = System.currentTimeMillis();
        this.executeBulk(bulkRequest, startTime, listener, new AtomicArray<BulkItemResponse>(bulkRequest.requests.size()));
    }

    private final long buildTookInMillis(long startTime) {
        return Math.max(1L, System.currentTimeMillis() - startTime);
    }

    private void executeBulk(BulkRequest bulkRequest, final long startTime, final ActionListener<BulkResponse> listener, final AtomicArray<BulkItemResponse> responses) {
        MappingMetaData mappingMd;
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState.metaData());
        MetaData metaData = clusterState.metaData();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocumentRequest req;
            ActionRequest request = bulkRequest.requests.get(i);
            if (!(request instanceof DocumentRequest) || this.addFailureIfIndexIsUnavailable(req = (DocumentRequest)((Object)request), bulkRequest, responses, i, concreteIndices, metaData)) continue;
            String concreteIndex = concreteIndices.resolveIfAbsent(req.index(), req.indicesOptions());
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                mappingMd = null;
                if (metaData.hasIndex(concreteIndex)) {
                    mappingMd = metaData.index(concreteIndex).mappingOrDefault(indexRequest.type());
                }
                try {
                    indexRequest.process(metaData, mappingMd, this.allowIdGeneration, concreteIndex);
                }
                catch (ElasticsearchParseException | RoutingMissingException e) {
                    BulkItemResponse.Failure failure = new BulkItemResponse.Failure(concreteIndex, indexRequest.type(), indexRequest.id(), e);
                    BulkItemResponse bulkItemResponse = new BulkItemResponse(i, "index", failure);
                    responses.set(i, bulkItemResponse);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            concreteIndices.resolveIfAbsent(req.index(), req.indicesOptions());
            req.routing(clusterState.metaData().resolveIndexRouting(req.routing(), req.index()));
        }
        HashMap requestsByShard = Maps.newHashMap();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            List<BulkItemRequest> list;
            ShardId shardId;
            String concreteIndex;
            ActionRequest request = bulkRequest.requests.get(i);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(indexRequest.index());
                ShardId shardId2 = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, indexRequest.type(), indexRequest.id(), indexRequest.routing()).shardId();
                ArrayList<BulkItemRequest> list2 = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId2);
                if (list2 == null) {
                    list2 = Lists.newArrayList();
                    requestsByShard.put(shardId2, list2);
                }
                list2.add(new BulkItemRequest(i, request));
                continue;
            }
            if (request instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(deleteRequest.index());
                mappingMd = clusterState.metaData().index(concreteIndex).mappingOrDefault(deleteRequest.type());
                if (mappingMd != null && mappingMd.routing().required() && deleteRequest.routing() == null) {
                    GroupShardsIterator groupShards = this.clusterService.operationRouting().broadcastDeleteShards(clusterState, concreteIndex);
                    for (ShardIterator shardIt : groupShards) {
                        ArrayList<BulkItemRequest> list3 = (ArrayList<BulkItemRequest>)requestsByShard.get(shardIt.shardId());
                        if (list3 == null) {
                            list3 = Lists.newArrayList();
                            requestsByShard.put(shardIt.shardId(), list3);
                        }
                        list3.add(new BulkItemRequest(i, new DeleteRequest(deleteRequest)));
                    }
                    continue;
                }
                shardId = this.clusterService.operationRouting().deleteShards(clusterState, concreteIndex, deleteRequest.type(), deleteRequest.id(), deleteRequest.routing()).shardId();
                list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId);
                if (list == null) {
                    list = Lists.newArrayList();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (!(request instanceof UpdateRequest)) continue;
            UpdateRequest updateRequest = (UpdateRequest)request;
            concreteIndex = concreteIndices.getConcreteIndex(updateRequest.index());
            mappingMd = clusterState.metaData().index(concreteIndex).mappingOrDefault(updateRequest.type());
            if (mappingMd != null && mappingMd.routing().required() && updateRequest.routing() == null) {
                BulkItemResponse.Failure failure = new BulkItemResponse.Failure(updateRequest.index(), updateRequest.type(), updateRequest.id(), "routing is required for this item", RestStatus.BAD_REQUEST);
                responses.set(i, new BulkItemResponse(i, updateRequest.type(), failure));
                continue;
            }
            shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, updateRequest.type(), updateRequest.id(), updateRequest.routing()).shardId();
            list = (List)requestsByShard.get(shardId);
            if (list == null) {
                list = Lists.newArrayList();
                requestsByShard.put(shardId, list);
            }
            list.add(new BulkItemRequest(i, request));
        }
        if (requestsByShard.isEmpty()) {
            listener.onResponse(new BulkResponse(responses.toArray((BulkItemResponse[])new BulkItemResponse[responses.length()]), this.buildTookInMillis(startTime)));
            return;
        }
        final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
        for (Map.Entry entry : requestsByShard.entrySet()) {
            ShardId shardId = (ShardId)entry.getKey();
            final List requests = (List)entry.getValue();
            BulkShardRequest bulkShardRequest = new BulkShardRequest(bulkRequest, shardId.index().name(), shardId.id(), bulkRequest.refresh(), requests.toArray(new BulkItemRequest[requests.size()]));
            bulkShardRequest.replicationType(bulkRequest.replicationType());
            bulkShardRequest.consistencyLevel(bulkRequest.consistencyLevel());
            bulkShardRequest.timeout(bulkRequest.timeout());
            this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                @Override
                public void onResponse(BulkShardResponse bulkShardResponse) {
                    for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                        responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    String message = ExceptionsHelper.detailedMessage(e);
                    RestStatus status = ExceptionsHelper.status(e);
                    for (BulkItemRequest request : requests) {
                        if (request.request() instanceof IndexRequest) {
                            IndexRequest indexRequest = (IndexRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), indexRequest.opType().toString().toLowerCase(Locale.ENGLISH), new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(indexRequest.index()), indexRequest.type(), indexRequest.id(), message, status)));
                            continue;
                        }
                        if (request.request() instanceof DeleteRequest) {
                            DeleteRequest deleteRequest = (DeleteRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), "delete", new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(deleteRequest.index()), deleteRequest.type(), deleteRequest.id(), message, status)));
                            continue;
                        }
                        if (!(request.request() instanceof UpdateRequest)) continue;
                        UpdateRequest updateRequest = (UpdateRequest)request.request();
                        responses.set(request.id(), new BulkItemResponse(request.id(), "update", new BulkItemResponse.Failure(concreteIndices.getConcreteIndex(updateRequest.index()), updateRequest.type(), updateRequest.id(), message, status)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), TransportBulkAction.this.buildTookInMillis(startTime)));
                }
            });
        }
    }

    private boolean addFailureIfIndexIsUnavailable(DocumentRequest request, BulkRequest bulkRequest, AtomicArray<BulkItemResponse> responses, int idx, ConcreteIndices concreteIndices, MetaData metaData) {
        IndexMetaData indexMetaData;
        String concreteIndex = concreteIndices.getConcreteIndex(request.index());
        IndexException unavailableException = null;
        if (concreteIndex == null) {
            try {
                concreteIndex = concreteIndices.resolveIfAbsent(request.index(), request.indicesOptions());
            }
            catch (IndexClosedException ice) {
                unavailableException = ice;
            }
            catch (IndexMissingException ime) {
                unavailableException = ime;
            }
        }
        if (unavailableException == null && (indexMetaData = metaData.index(concreteIndex)).getState() == IndexMetaData.State.CLOSE) {
            unavailableException = new IndexClosedException(new Index(metaData.index(request.index()).getIndex()));
        }
        if (unavailableException != null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.type(), request.id(), unavailableException);
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, "index", failure);
            responses.set(idx, bulkItemResponse);
            bulkRequest.requests.set(idx, null);
            return true;
        }
        return false;
    }

    private static class ConcreteIndices {
        private final Map<String, String> indices = new HashMap<String, String>();
        private final MetaData metaData;

        ConcreteIndices(MetaData metaData) {
            this.metaData = metaData;
        }

        String getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        String resolveIfAbsent(String indexOrAlias, IndicesOptions indicesOptions) {
            String concreteIndex = this.indices.get(indexOrAlias);
            if (concreteIndex == null) {
                concreteIndex = this.metaData.concreteSingleIndex(indexOrAlias, indicesOptions);
                this.indices.put(indexOrAlias, concreteIndex);
            }
            return concreteIndex;
        }
    }
}

