/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexAction
extends TransportMasterNodeOperationAction<DeleteIndexRequest, DeleteIndexResponse> {
    private final MetaDataDeleteIndexService deleteIndexService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportDeleteIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataDeleteIndexService deleteIndexService, NodeSettingsService nodeSettingsService, ActionFilters actionFilters) {
        super(settings, "indices:admin/delete", transportService, clusterService, threadPool, actionFilters);
        this.deleteIndexService = deleteIndexService;
        this.destructiveOperations = new DestructiveOperations(this.logger, settings, nodeSettingsService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected DeleteIndexRequest newRequest() {
        return new DeleteIndexRequest();
    }

    @Override
    protected DeleteIndexResponse newResponse() {
        return new DeleteIndexResponse();
    }

    @Override
    protected void doExecute(DeleteIndexRequest request, ActionListener<DeleteIndexResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, state.metaData().concreteIndices(request.indicesOptions(), request.indices()));
    }

    @Override
    protected void masterOperation(DeleteIndexRequest request, ClusterState state, final ActionListener<DeleteIndexResponse> listener) throws ElasticsearchException {
        String[] concreteIndices = state.metaData().concreteIndices(request.indicesOptions(), request.indices());
        if (concreteIndices.length == 0) {
            listener.onResponse(new DeleteIndexResponse(true));
            return;
        }
        final CountDown count = new CountDown(concreteIndices.length);
        for (final String index : concreteIndices) {
            this.deleteIndexService.deleteIndex(new MetaDataDeleteIndexService.Request(index).timeout(request.timeout()).masterTimeout(request.masterNodeTimeout()), new MetaDataDeleteIndexService.Listener(){
                private volatile Throwable lastFailure;
                private volatile boolean ack = true;

                @Override
                public void onResponse(MetaDataDeleteIndexService.Response response) {
                    if (!response.acknowledged()) {
                        this.ack = false;
                    }
                    if (count.countDown()) {
                        if (this.lastFailure != null) {
                            listener.onFailure(this.lastFailure);
                        } else {
                            listener.onResponse(new DeleteIndexResponse(this.ack));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    TransportDeleteIndexAction.this.logger.debug("[{}] failed to delete index", t, index);
                    this.lastFailure = t;
                    if (count.countDown()) {
                        listener.onFailure(t);
                    }
                }
            });
        }
    }
}

