/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

class ShardClearIndicesCacheRequest
extends BroadcastShardOperationRequest {
    private boolean filterCache = false;
    private boolean fieldDataCache = false;
    private boolean idCache = false;
    private boolean recycler;
    private boolean queryCache = false;
    private String[] fields = null;
    private String[] filterKeys = null;

    ShardClearIndicesCacheRequest() {
    }

    ShardClearIndicesCacheRequest(ShardId shardId, ClearIndicesCacheRequest request) {
        super(shardId, request);
        this.filterCache = request.filterCache();
        this.fieldDataCache = request.fieldDataCache();
        this.idCache = request.idCache();
        this.fields = request.fields();
        this.filterKeys = request.filterKeys();
        this.recycler = request.recycler();
        this.queryCache = request.queryCache();
    }

    public boolean filterCache() {
        return this.filterCache;
    }

    public boolean queryCache() {
        return this.queryCache;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public boolean idCache() {
        return this.idCache;
    }

    public boolean recycler() {
        return this.recycler;
    }

    public String[] fields() {
        return this.fields;
    }

    public String[] filterKeys() {
        return this.filterKeys;
    }

    public ShardClearIndicesCacheRequest waitForOperations(boolean waitForOperations) {
        this.filterCache = waitForOperations;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.idCache = in.readBoolean();
        this.recycler = in.readBoolean();
        this.fields = in.readStringArray();
        this.filterKeys = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.queryCache = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.idCache);
        out.writeBoolean(this.recycler);
        out.writeStringArrayNullable(this.fields);
        out.writeStringArrayNullable(this.filterKeys);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.queryCache);
        }
    }
}

