/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class ClusterHealthRequest
extends MasterNodeReadOperationRequest<ClusterHealthRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private TimeValue timeout = new TimeValue(30L, TimeUnit.SECONDS);
    private ClusterHealthStatus waitForStatus;
    private int waitForRelocatingShards = -1;
    private int waitForActiveShards = -1;
    private String waitForNodes = "";
    private Priority waitForEvents = null;

    ClusterHealthRequest() {
    }

    public ClusterHealthRequest(String ... indices) {
        this.indices = indices;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public ClusterHealthRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public ClusterHealthRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        if (this.masterNodeTimeout == DEFAULT_MASTER_NODE_TIMEOUT) {
            this.masterNodeTimeout = timeout;
        }
        return this;
    }

    public ClusterHealthRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    public ClusterHealthStatus waitForStatus() {
        return this.waitForStatus;
    }

    public ClusterHealthRequest waitForStatus(ClusterHealthStatus waitForStatus) {
        this.waitForStatus = waitForStatus;
        return this;
    }

    public ClusterHealthRequest waitForGreenStatus() {
        return this.waitForStatus(ClusterHealthStatus.GREEN);
    }

    public ClusterHealthRequest waitForYellowStatus() {
        return this.waitForStatus(ClusterHealthStatus.YELLOW);
    }

    public int waitForRelocatingShards() {
        return this.waitForRelocatingShards;
    }

    public ClusterHealthRequest waitForRelocatingShards(int waitForRelocatingShards) {
        this.waitForRelocatingShards = waitForRelocatingShards;
        return this;
    }

    public int waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ClusterHealthRequest waitForActiveShards(int waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public String waitForNodes() {
        return this.waitForNodes;
    }

    public ClusterHealthRequest waitForNodes(String waitForNodes) {
        this.waitForNodes = waitForNodes;
        return this;
    }

    public ClusterHealthRequest waitForEvents(Priority waitForEvents) {
        this.waitForEvents = waitForEvents;
        return this;
    }

    public Priority waitForEvents() {
        return this.waitForEvents;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        if (size == 0) {
            this.indices = Strings.EMPTY_ARRAY;
        } else {
            this.indices = new String[size];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = in.readString();
            }
        }
        this.timeout = TimeValue.readTimeValue(in);
        if (in.readBoolean()) {
            this.waitForStatus = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.waitForRelocatingShards = in.readInt();
        this.waitForActiveShards = in.readInt();
        this.waitForNodes = in.readString();
        this.readLocal(in);
        if (in.readBoolean()) {
            this.waitForEvents = Priority.readFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index : this.indices) {
                out.writeString(index);
            }
        }
        this.timeout.writeTo(out);
        if (this.waitForStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.waitForStatus.value());
        }
        out.writeInt(this.waitForRelocatingShards);
        out.writeInt(this.waitForActiveShards);
        out.writeString(this.waitForNodes);
        this.writeLocal(out);
        if (this.waitForEvents == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Priority.writeTo(this.waitForEvents, out);
        }
    }
}

