/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.DeadlockDetectionConfiguration;

public class DeadlockDetectionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<DeadlockDetectionConfiguration> {
    private boolean enabled = false;
    private long spinDuration = TimeUnit.MILLISECONDS.toMillis(100L);

    DeadlockDetectionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public DeadlockDetectionConfigurationBuilder spinDuration(long l) {
        this.spinDuration = l;
        return this;
    }

    public DeadlockDetectionConfigurationBuilder spinDuration(long l, TimeUnit unit) {
        return this.spinDuration(unit.toMillis(l));
    }

    public DeadlockDetectionConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public DeadlockDetectionConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public DeadlockDetectionConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void validate() {
    }

    public DeadlockDetectionConfiguration create() {
        return new DeadlockDetectionConfiguration(this.enabled, this.spinDuration);
    }

    public DeadlockDetectionConfigurationBuilder read(DeadlockDetectionConfiguration template) {
        this.enabled = template.enabled();
        this.spinDuration = template.spinDuration();
        return this;
    }

    public String toString() {
        return "DeadlockDetectionConfigurationBuilder{enabled=" + this.enabled + ", spinDuration=" + this.spinDuration + '}';
    }
}

