/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public class BytesRefFieldSource
extends FieldCacheSource {
    public BytesRefFieldSource(String field) {
        super(field);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        FieldInfo fieldInfo = readerContext.reader().getFieldInfos().fieldInfo(this.field);
        if (fieldInfo != null && fieldInfo.getDocValuesType() == FieldInfo.DocValuesType.BINARY) {
            final BinaryDocValues binaryValues = FieldCache.DEFAULT.getTerms(readerContext.reader(), this.field, true);
            final Bits docsWithField = FieldCache.DEFAULT.getDocsWithField(readerContext.reader(), this.field);
            return new FunctionValues(){

                @Override
                public boolean exists(int doc) {
                    return docsWithField.get(doc);
                }

                @Override
                public boolean bytesVal(int doc, BytesRef target) {
                    target.copyBytes(binaryValues.get(doc));
                    return target.length > 0;
                }

                @Override
                public String strVal(int doc) {
                    BytesRef bytes = new BytesRef();
                    return this.bytesVal(doc, bytes) ? bytes.utf8ToString() : null;
                }

                @Override
                public Object objectVal(int doc) {
                    return this.strVal(doc);
                }

                @Override
                public String toString(int doc) {
                    return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
                }

                @Override
                public FunctionValues.ValueFiller getValueFiller() {
                    return new FunctionValues.ValueFiller(){
                        private final MutableValueStr mval = new MutableValueStr();

                        @Override
                        public MutableValue getValue() {
                            return this.mval;
                        }

                        @Override
                        public void fillValue(int doc) {
                            this.mval.exists = docsWithField.get(doc);
                            this.mval.value.copyBytes(binaryValues.get(doc));
                        }
                    };
                }
            };
        }
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc) {
                return this.strVal(doc);
            }

            @Override
            public String toString(int doc) {
                return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }
}

