/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ConfigurationItemRevision;
import com.xebialabs.deployit.repository.HistoryService;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReader;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrHistoryService
implements HistoryService {
    private final JcrTemplate jcrTemplate;
    private final PasswordEncrypter passwordEncrypter;
    private static final Logger logger = LoggerFactory.getLogger(JcrHistoryService.class);

    @Autowired
    public JcrHistoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter) {
        this.jcrTemplate = jcrTemplate;
        this.passwordEncrypter = passwordEncrypter;
    }

    public List<ConfigurationItemRevision> getVersionRevisions(final String id) {
        logger.debug("Retrieving version history for node {}.", (Object)id);
        return this.jcrTemplate.execute(new JcrCallback<List<ConfigurationItemRevision>>(){

            @Override
            public List<ConfigurationItemRevision> doInJcr(Session session) throws RepositoryException {
                ArrayList items = Lists.newArrayList();
                String absPath = JcrPathHelper.getAbsolutePathFromId(id);
                if (session.getNode(absPath).isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                    VersionHistory history = session.getWorkspace().getVersionManager().getVersionHistory(absPath);
                    Version rootVersion = history.getRootVersion();
                    VersionIterator versions = history.getAllLinearVersions();
                    while (versions.hasNext()) {
                        Version version = versions.nextVersion();
                        if (version.getName().equals(rootVersion.getName())) continue;
                        String name = version.getName();
                        Node frozenNode = version.getFrozenNode();
                        items.add(JcrHistoryService.this.getConfigurationItemRevision(name, frozenNode));
                    }
                }
                items.add(JcrHistoryService.this.getConfigurationItemRevision("current", session.getNode(absPath)));
                return items;
            }
        });
    }

    private ConfigurationItemRevision getConfigurationItemRevision(String name, Node frozenNode) throws RepositoryException {
        Calendar created = frozenNode.getProperty("$lastModified").getDate();
        String username = "<system>";
        if (frozenNode.hasProperty("$creatingUser")) {
            username = frozenNode.getProperty("$creatingUser").getString();
        }
        return new ConfigurationItemRevision(name, created, username);
    }

    public <T extends ConfigurationItem> T readRevision(final String id, final String revisionName) {
        logger.debug("Retrieving revision [{}] for [{}]", (Object)revisionName, (Object)id);
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws RepositoryException {
                VersionHistory history = session.getWorkspace().getVersionManager().getVersionHistory(JcrPathHelper.getAbsolutePathFromId(id));
                Version version = JcrHistoryService.this.getVersionByRevisionName(history, revisionName, id);
                return JcrHistoryService.this.readNode(session, version, id);
            }
        }));
    }

    public <T extends ConfigurationItem> T readRevisionByLabel(final String id, final String label) {
        logger.debug("Retrieving revision labelled as [{}] for  label[{}]", (Object)label, (Object)id);
        return (T)((ConfigurationItem)this.jcrTemplate.execute(new JcrCallback<T>(){

            @Override
            public T doInJcr(Session session) throws RepositoryException {
                Version version;
                VersionHistory history = session.getWorkspace().getVersionManager().getVersionHistory(JcrPathHelper.getAbsolutePathFromId(id));
                try {
                    version = history.getVersionByLabel(label);
                }
                catch (VersionException ve) {
                    throw new UnknownLabelException("Cannot find revision labelled as [%s] for configuration item [%s]", label, id);
                }
                return JcrHistoryService.this.readNode(session, version, id);
            }
        }));
    }

    public void labelRevision(final String id, final String revisionName, final String label) {
        logger.debug("Labelling revision [{}] for [{}] with label [{}]", new Object[]{revisionName, id, label});
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws RepositoryException {
                VersionHistory history = session.getWorkspace().getVersionManager().getVersionHistory(JcrPathHelper.getAbsolutePathFromId(id));
                Version version = JcrHistoryService.this.getVersionByRevisionName(history, revisionName, id);
                history.addVersionLabel(version.getName(), label, true);
                return null;
            }
        });
    }

    private Version getVersionByRevisionName(VersionHistory history, String revisionName, String id) throws RepositoryException {
        Version version;
        try {
            version = history.getVersion(revisionName);
        }
        catch (VersionException ve) {
            throw new UnknownRevisionException("Cannot find revision [%s] for configuration item [%s]", revisionName, id);
        }
        return version;
    }

    private <T extends ConfigurationItem> T readNode(Session session, Version version, String id) throws RepositoryException {
        Node node = version.getFrozenNode();
        Object item = NodeReader.read(session, node, Integer.MAX_VALUE, null, this.passwordEncrypter);
        item.setId(id);
        return item;
    }

    @HttpResponseCodeResult(statusCode=404)
    public static class UnknownLabelException
    extends DeployitException {
        public UnknownLabelException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }

    @HttpResponseCodeResult(statusCode=404)
    public static class UnknownRevisionException
    extends DeployitException {
        public UnknownRevisionException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }
}

