/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.importers;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.PerformanceResultsSummary;
import com.xebialabs.xltest.importers.AbstractPerformanceResultsImporter;
import java.util.UUID;

public abstract class AbstractPerformanceSummaryResultsImporter
extends AbstractPerformanceResultsImporter {
    private PerformanceResultsSummary performanceResultsSummary;

    @Override
    public Event createImportStartedEvent(UUID testRunId) {
        return Event.withRunId(testRunId, "importStarted").setLastModified(this.getTimestamp()).setFileName(this.getImportablePath());
    }

    @Override
    public Event createPerformanceResultsEvent(UUID testRunId) throws ImportException {
        this.performanceResultsSummary = this.constructPerformanceResultsSummary();
        return this.performanceResultsSummary.createPerformanceResultEvent(testRunId);
    }

    @Override
    public Event createImportFinishedEvent(UUID testRunId) {
        if (this.performanceResultsSummary != null) {
            return Event.withRunId(testRunId, "importFinished").setDuration(this.performanceResultsSummary.getDuration());
        }
        return Event.withRunId(testRunId, "importFinished").setFailureReason("No performance result has be calculated");
    }

    public abstract String getImportablePath();

    public abstract PerformanceResultsSummary constructPerformanceResultsSummary() throws ImportException;
}

