/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Event
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(Event.class);
    public static final String TESTNAME_DELIMITER = ";";
    public static final String ID = "_id";
    public static final String RUN_ID = "runId";
    public static final String TIMESTAMP = "timestamp";
    public static final String TYPE = "type";
    public static final String TEST_SPECIFICATION = "testSpecification";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String TAGS = "tags";
    public static final String EXECUTION_STARTED = "executionStarted";
    public static final String EXECUTION_FINISHED = "executionFinished";
    public static final String IMPORT_STARTED = "importStarted";
    public static final String IMPORT_FINISHED = "importFinished";
    public static final String FUNCTIONAL_RESULT = "functionalResult";
    public static final String PERFORMANCE_RESULT = "performanceResult";
    public static final String QUALIFICATION_COMPUTED = "qualificationComputed";
    public static final String UNKNOWN_EVENT_TYPE = "UNKNOWN";
    public static final String QUALIFICATION = "qualification";
    public static final String FAILURE_REASON = "failureReason";
    public static final String CHILD_RUN_ID = "childRunId";
    public static final String CHILD_FINISHED = "childFinished";
    public static final String CHILD_STARTED = "childStarted";
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    public Event(Map<String, Object> properties) {
        this.properties.putAll(properties);
        if (!this.properties.containsKey(TIMESTAMP)) {
            this.update(TIMESTAMP, System.currentTimeMillis());
        }
    }

    public Event(String type) {
        this(new HashMap<String, Object>());
        this.update(TYPE, type);
    }

    public Event(String type, Map<String, Object> properties) {
        this(properties);
        this.update(TYPE, type);
    }

    public Event(Event event, Map<String, Object> properties) {
        this(event.getProperties());
        this.properties.putAll(properties);
    }

    public Event(UUID testRunId, Event event, Map<String, Object> properties) {
        this(event.getProperties());
        this.properties.putAll(properties);
        this.properties.put(RUN_ID, testRunId.toString());
    }

    public static Event withRunId(UUID testRunId, String type) {
        return new Event(testRunId, type, new HashMap<String, Object>());
    }

    public static Event withId(String id, Map<String, Object> properties) {
        Event e = new Event(properties);
        e.properties.put(ID, id);
        return e;
    }

    public Event(UUID testRunId, String type, Map<String, Object> properties) {
        this(properties);
        this.update(RUN_ID, testRunId.toString());
        this.update(TYPE, type);
    }

    public String getType() {
        return (String)this.properties.get(TYPE);
    }

    public Event update(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Event updateWithProperties(Map<String, Object> otherProperties) {
        this.properties.putAll(otherProperties);
        return this;
    }

    public <T> T get(String key) {
        Object value = this.properties.get(key);
        return (T)value;
    }

    public <T> T getRequired(String key) {
        T value = this.get(key);
        if (value == null) {
            throw new KeyNotFoundException(this, key);
        }
        return value;
    }

    public boolean hasProperty(String key) {
        return this.properties.get(key) != null;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return this.properties.equals(event.properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public String toString() {
        return "Event" + this.properties;
    }

    public static Map<String, Object> props(Map<String, Object> map, Object ... keyValues) {
        assert (keyValues.length % 2 == 0);
        TreeMap<String, Object> m = new TreeMap<String, Object>(map);
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            m.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return m;
    }

    public static Map<String, Object> props(Object ... keyValues) {
        assert (keyValues.length % 2 == 0);
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            m.put(keyValues[i].toString(), keyValues[i + 1]);
        }
        return m;
    }

    public String getId() {
        return (String)this.get(ID);
    }

    public String getTestSpecification() {
        return (String)this.get(TEST_SPECIFICATION);
    }

    public Date getTimestampAsDate() {
        return new Date(this.getTimestamp());
    }

    public long getTimestamp() {
        return this.getLongFromProperties(TIMESTAMP);
    }

    public Event setTimestamp(long timestamp) {
        this.update(TIMESTAMP, timestamp);
        return this;
    }

    public String getName() {
        return (String)this.get("name");
    }

    public String getFileName() {
        return (String)this.get("fileName");
    }

    public Event setFileName(String fileName) {
        return this.update("fileName", fileName);
    }

    public Event setLastModified(long lastModified) {
        return this.update(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getLongFromProperties(LAST_MODIFIED);
    }

    public Event setDuration(int totalDuration) {
        return this.update("duration", totalDuration);
    }

    public int getDuration() {
        try {
            return this.getIntFromProperties("duration");
        }
        catch (ClassCastException e) {
            LOG.error("ClassCastException occurred while retrieving duration. Value of 'duration' is : {}. Of type: {}. Event properties: {}, Stacktrace: {}", new Object[]{this.get("duration"), this.get("duration").getClass(), this.getProperties(), e});
            throw e;
        }
    }

    public long getTotalNumberOfRequests() {
        return this.getLongFromProperties("numberOfRequests.total");
    }

    public Event setTotalNumberOfRequests(long totalNumberOfRequests) {
        return this.update("numberOfRequests.total", totalNumberOfRequests);
    }

    public Event setTotalNumberOfOkRequests(long totalNumberOfOkRequests) {
        return this.update("numberOfRequests.ok", totalNumberOfOkRequests);
    }

    public long getTotalNumberOfOkRequests() {
        return this.getLongFromProperties("numberOfRequests.ok");
    }

    public Event setTotalNumberOfNotOkRequests(long totalNumberOfNotOkRequests) {
        return this.update("numberOfRequests.ko", totalNumberOfNotOkRequests);
    }

    public long getTotalNumberOfNotOkRequests() {
        return this.getLongFromProperties("numberOfRequests.ko");
    }

    public Event setMinResponseTime(long minResponseTime) {
        return this.update("minResponseTime.total", minResponseTime);
    }

    public long getMinResponseTime() {
        return this.getLongFromProperties("minResponseTime.total");
    }

    public Event setMinResponseTimeOk(long minResponseTimeOk) {
        return this.update("minResponseTime.ok", minResponseTimeOk);
    }

    public long getMinResponseTimeOk() {
        return this.getLongFromProperties("minResponseTime.ok");
    }

    public Event setMinResponseTimeNotOk(long minResponseTimeNotOk) {
        return this.update("minResponseTime.ko", minResponseTimeNotOk);
    }

    public long getMinResponseTimeNotOk() {
        return this.getLongFromProperties("minResponseTime.ko");
    }

    public Event setMaxResponseTime(long maxResponseTime) {
        return this.update("maxResponseTime.total", maxResponseTime);
    }

    public long getMaxResponseTime() {
        return this.getLongFromProperties("maxResponseTime.total");
    }

    public Event setMaxResponseTimeOk(long maxResponseTimeOk) {
        return this.update("maxResponseTime.ok", maxResponseTimeOk);
    }

    public long getMaxResponseTimeOk() {
        return this.getLongFromProperties("maxResponseTime.ok");
    }

    public Event setMaxResponseTimeNotOk(long maxResponseTimeNotOk) {
        return this.update("maxResponseTime.ko", maxResponseTimeNotOk);
    }

    public long getMaxResponseTimeNotOk() {
        return this.getLongFromProperties("maxResponseTime.ko");
    }

    public Event setMeanResponseTime(long meanResponseTime) {
        return this.update("meanResponseTime.total", meanResponseTime);
    }

    public long getMeanResponseTime() {
        return this.getLongFromProperties("meanResponseTime.total");
    }

    public Event setMeanResponseTimeOk(long meanResponseTimeOk) {
        return this.update("meanResponseTime.ok", meanResponseTimeOk);
    }

    public long getMeanResponseTimeOk() {
        return this.getLongFromProperties("meanResponseTime.ok");
    }

    public Event setMeanResponseTimeNotOk(long meanResponseTimeNotOk) {
        return this.update("meanResponseTime.ko", meanResponseTimeNotOk);
    }

    public long getMeanResponseTimeNotOk() {
        return this.getLongFromProperties("meanResponseTime.ko");
    }

    public double getStandardDeviation() {
        return this.getDoubleFromProperties("standardDeviation.total");
    }

    public Event setStandardDeviation(double standardDeviation) {
        return this.update("standardDeviation.total", standardDeviation);
    }

    public double getStandardDeviationOk() {
        return this.getDoubleFromProperties("standardDeviation.ok");
    }

    public Event setStandardDeviationOk(double standardDeviationOk) {
        return this.update("standardDeviation.ok", standardDeviationOk);
    }

    public double getStandardDeviationNotOk() {
        return this.getDoubleFromProperties("standardDeviation.ko");
    }

    public Event setStandardDeviationNotOk(double standardDeviationNotOk) {
        return this.update("standardDeviation.ko", standardDeviationNotOk);
    }

    public Event setSimulationName(String simulationName) {
        return this.update("simulationName", simulationName);
    }

    public String getSimulationName() {
        return (String)this.get("simulationName");
    }

    public Event setFailureReason(String message) {
        return this.update(FAILURE_REASON, message);
    }

    public UUID getTestRunId() {
        Object testRunId = this.get(RUN_ID);
        if (testRunId instanceof UUID) {
            return (UUID)testRunId;
        }
        try {
            return UUID.fromString(testRunId.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Event malformed, no valid runId: " + this.toString());
        }
    }

    public static String normalizeName(String pageName, Character separator) {
        if (pageName.indexOf(separator.charValue()) > -1) {
            return pageName.replace(separator.charValue(), ';');
        }
        return pageName;
    }

    private long getLongFromProperties(String key) {
        Long value = (Long)this.get(key);
        if (value != null) {
            return value;
        }
        return -1L;
    }

    private int getIntFromProperties(String key) {
        Integer value = (Integer)this.get(key);
        if (value != null) {
            return value;
        }
        return -1;
    }

    private double getDoubleFromProperties(String key) {
        Double value = (Double)this.get(key);
        if (value != null) {
            return value;
        }
        return -1.0;
    }

    public Event addTags(List<String> tags) {
        this.updateWithProperties(Collections.singletonMap(TAGS, tags));
        return this;
    }

    public List<String> getTags() {
        List tags = (List)this.get(TAGS);
        if (tags == null) {
            tags = Lists.newArrayList();
        }
        return tags;
    }

    public void setTestSpecificationName(String testSpecificationName) {
        if (StringUtils.hasText((String)this.getTestSpecification())) {
            throw new IllegalStateException("It is not allowed to change the test specification name an event, because it is set to " + this.getTestSpecification());
        }
        this.update(TEST_SPECIFICATION, testSpecificationName);
    }

    public static Event createImportStartedEvent(UUID testRunId, String testSpecificationName, long lastModified) {
        Event event = Event.withRunId(testRunId, IMPORT_STARTED);
        event.setTestSpecificationName(testSpecificationName);
        event.setLastModified(lastModified);
        return event;
    }

    public static Event createImportFinishedEvent(UUID testRunId, int duration) {
        return Event.withRunId(testRunId, IMPORT_FINISHED).setDuration(duration);
    }

    private static class KeyNotFoundException
    extends RuntimeException {
        public KeyNotFoundException(Event event, String key) {
            super("key [" + key + "] not found for event " + event);
        }
    }
}

