package com.xebialabs.xltest.testtools.fitnesse;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import com.google.common.base.Preconditions;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlt.plugin.api.resultparser.ImportFailedException;
import com.xebialabs.xlt.plugin.api.resultparser.TestResultParser;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorianAware;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.resultparser.ImportException;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorian;

import fitnesse.FitNesseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FitNesseTestResultParser implements TestResultParser, TestRunHistorianAware {
    private static final Logger LOG = LoggerFactory.getLogger(FitNesseTestResultParser.class);

    private TestRunHistorian testRunHistorian;

    @Override
    public List<List<Event>> generateEventsFromFiles(List<OverthereFile> testResultFiles) throws ImportException {
        String testRunId = UUID.randomUUID().toString();
        List<List<Event>> result = new ArrayList<>();
        List<OverthereFile> filteredList = new ArrayList<OverthereFile>();
        for (OverthereFile file : testResultFiles) {
            if (file.isDirectory() && file.getName().equals("FitNesseRoot")) {
                filteredList.add(file);
            }
        }
        if (filteredList.size() <= 0) {
            throw new ImportFailedException("Could not find FitNesse results. Please verify that the imported files are for FitNesse, and that they are in files/"
                + FitNesseContext.testResultsDirectoryName + ".");
        }
        for (OverthereFile fitNesseRoot : filteredList) {
            LocalFile localFile = (LocalFile) fitNesseRoot;
            File file = localFile.getFile();
            // for each fitnesse root, find their page history, etc bla bla
            FitnesseSuiteImporterFactory fitnesseSuiteImporterFactory = new FitnesseSuiteImporterFactory(file);
            List<FitNesseSuiteImporter> importables = fitnesseSuiteImporterFactory.create();
            LOG.debug("Found {} suites ", importables.size());
            for (FitNesseSuiteImporter suiteImporter : importables) {
                final String runKey = Long.toString(suiteImporter.getLastModified());
                if (testRunHistorian.isKnownKey(runKey)) {
                    LOG.debug("Suite with key {} has already been imported", runKey);
                } else {
                    LOG.debug("Importing suite with key {}", runKey);
                    List<Event> events = suiteImporter.mapSuiteToEvents(testRunId);
                    result.add(events);
                    testRunId = UUID.randomUUID().toString();
                }
            }
        }
        return result;
    }

    @Override
    public void setTestRunHistorian(final TestRunHistorian testRunHistorian) {
        this.testRunHistorian = Preconditions.checkNotNull(testRunHistorian, "testRunHistorian is required");
    }
}
