/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.mem;

import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wiki.mem.MemoryFileSystem;
import fitnesse.wiki.mem.MemoryVersionsController;
import java.io.File;
import java.util.Properties;

public class InMemoryPage {
    public static WikiPage makeRoot(String name) {
        return InMemoryPage.makeRoot(name, null, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, MemoryFileSystem fileSystem) {
        return InMemoryPage.makeRoot(name, null, fileSystem);
    }

    public static WikiPage makeRoot(String name, Properties properties) {
        return InMemoryPage.makeRoot(name, properties, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, Properties properties, MemoryFileSystem fileSystem) {
        FileSystemPageFactory factory = new FileSystemPageFactory(fileSystem, new MemoryVersionsController(fileSystem), new SystemVariableSource(properties));
        FileSystemPage page = (FileSystemPage)factory.makePage(new File("."), name, null);
        return page;
    }

    public static WikiPage createChildPage(String name, FileSystemPage parent) {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        return new FileSystemPage(new File(parent.getFileSystemPath(), name), name, parent, new MemoryVersionsController(fileSystem));
    }
}

