/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import java.util.ArrayList;
import java.util.List;
import util.ListUtility;

public class TableTable
extends SlimTable {
    public TableTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    @Override
    protected String getTableType() {
        return "tableTable";
    }

    @Override
    public List<SlimAssertion> getAssertions() {
        SlimAssertion make = this.constructFixture(this.getFixtureName());
        Instruction doTable = this.callFunction(this.getTableName(), "doTable", this.tableAsList());
        String doTableId = doTable.getId();
        return ListUtility.list(make, this.makeAssertion(doTable, new TableTableExpectation()));
    }

    private TestSummary resizeTableAndEvaluateRows(Object returnValue) {
        List tableResults = (List)returnValue;
        this.extendTable(this.table, tableResults);
        TestSummary testSummary = new TestSummary();
        for (int row = 0; row < tableResults.size(); ++row) {
            this.evaluateRow(tableResults, row, testSummary);
        }
        return testSummary;
    }

    private void extendTable(Table table, List<List<Object>> tableResults) {
        this.addNewRows(table, tableResults);
        this.extendExistingRows(table, tableResults);
    }

    private void addNewRows(Table table, List<List<Object>> tableResults) {
        while (table.getRowCount() - 1 < tableResults.size()) {
            ArrayList<String> l = new ArrayList<String>();
            for (Object s : tableResults.get(table.getRowCount() - 1)) {
                l.add((String)s);
            }
            table.addRow(l);
        }
    }

    private void extendExistingRows(Table table, List<List<Object>> tableResults) {
        for (int row = 1; row < tableResults.size(); ++row) {
            this.extendRow(table, row, tableResults.get(row - 1));
        }
    }

    private void extendRow(Table table, int row, List<Object> cellList) {
        while (table.getColumnCountInRow(row) < cellList.size()) {
            table.addColumnToRow(row, (String)cellList.get(table.getColumnCountInRow(row)));
        }
    }

    private void evaluateRow(List<List<Object>> tableResults, int resultRow, TestSummary testSummary) {
        List<Object> rowList = tableResults.get(resultRow);
        for (int col = 0; col < rowList.size(); ++col) {
            int tableRow = resultRow + 1;
            String contents = this.table.getCellContents(col, tableRow);
            String result = (String)rowList.get(col);
            SlimTestResult testResult = this.getTestResult(result, this.replaceSymbolsWithFullExpansion(contents));
            if (testResult == null) continue;
            this.table.updateContent(col, tableRow, testResult);
            testSummary.add(testResult.getExecutionResult());
        }
    }

    private SlimTestResult getTestResult(String message, String content) {
        SlimTestResult result;
        if (message.equalsIgnoreCase("no change") || message.length() == 0) {
            return null;
        }
        if (message.equalsIgnoreCase("pass")) {
            result = SlimTestResult.pass(content);
        } else if (message.equalsIgnoreCase("fail")) {
            result = SlimTestResult.fail(content);
        } else if (message.equalsIgnoreCase("ignore")) {
            result = SlimTestResult.ignore();
        } else {
            result = this.resultFromMessage(message);
            if (result == null) {
                result = SlimTestResult.fail(message);
            }
        }
        return result;
    }

    private SlimTestResult resultFromMessage(String contents) {
        int colon = contents.indexOf(":");
        if (colon == -1) {
            return null;
        }
        String code = contents.substring(0, colon);
        String message = contents.substring(colon + 1);
        if (code.equalsIgnoreCase("error")) {
            return SlimTestResult.error(message);
        }
        if (code.equalsIgnoreCase("fail")) {
            return SlimTestResult.fail(message);
        }
        if (code.equalsIgnoreCase("pass")) {
            return SlimTestResult.pass(message);
        }
        if (code.equalsIgnoreCase("ignore")) {
            return SlimTestResult.ignore(message);
        }
        if (code.equalsIgnoreCase("report")) {
            return SlimTestResult.plain(message);
        }
        return null;
    }

    public class TableTableExpectation
    implements SlimExpectation {
        @Override
        public TestResult evaluateExpectation(Object tableReturn) {
            SlimTestResult testResult;
            if (tableReturn == null || "null".equals(tableReturn)) {
                testResult = SlimTestResult.ignore("No results from table");
                TableTable.this.table.updateContent(TableTable.this.table.getColumnCountInRow(0) - 1, 0, testResult);
            } else if (tableReturn instanceof String) {
                testResult = SlimTestResult.error((String)tableReturn);
                TableTable.this.table.updateContent(0, 0, testResult);
            } else {
                TestSummary testSummary = TableTable.this.resizeTableAndEvaluateRows(tableReturn);
                TableTable.this.getTestContext().increment(testSummary);
                testResult = new SlimTestResult(ExecutionResult.getExecutionResult(testSummary));
            }
            TableTable.this.getTestContext().increment(testResult.getExecutionResult());
            return testResult;
        }

        @Override
        public SlimExceptionResult evaluateException(SlimExceptionResult exceptionResult) {
            TableTable.this.table.updateContent(0, 0, exceptionResult);
            TableTable.this.getTestContext().incrementErroredTestsCount();
            return exceptionResult;
        }
    }
}

